/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.swagger;

import com.networknt.handler.config.EndpointSource;
import com.networknt.swagger.SwaggerHelper;
import io.swagger.models.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerEndpointSource
implements EndpointSource {
    private static final Logger log = LoggerFactory.getLogger(SwaggerEndpointSource.class);

    public Iterable<EndpointSource.Endpoint> listEndpoints() {
        ArrayList<EndpointSource.Endpoint> endpoints = new ArrayList<EndpointSource.Endpoint>();
        String basePath = this.findBasePath();
        Map paths = SwaggerHelper.swagger.getPaths();
        if (log.isInfoEnabled()) {
            log.info("Generating paths from Swagger spec");
        }
        for (Map.Entry pathPair : paths.entrySet()) {
            String path = basePath + (String)pathPair.getKey();
            Path pathImpl = (Path)pathPair.getValue();
            if (pathImpl.getGet() != null) {
                SwaggerEndpointSource.addEndpoint(endpoints, path, "get");
            }
            if (pathImpl.getPut() != null) {
                SwaggerEndpointSource.addEndpoint(endpoints, path, "put");
            }
            if (pathImpl.getHead() != null) {
                SwaggerEndpointSource.addEndpoint(endpoints, path, "head");
            }
            if (pathImpl.getPost() != null) {
                SwaggerEndpointSource.addEndpoint(endpoints, path, "post");
            }
            if (pathImpl.getDelete() != null) {
                SwaggerEndpointSource.addEndpoint(endpoints, path, "delete");
            }
            if (pathImpl.getPatch() != null) {
                SwaggerEndpointSource.addEndpoint(endpoints, path, "patch");
            }
            if (pathImpl.getOptions() == null) continue;
            SwaggerEndpointSource.addEndpoint(endpoints, path, "options");
        }
        return endpoints;
    }

    private static void addEndpoint(List<EndpointSource.Endpoint> endpoints, String path, String method) {
        EndpointSource.Endpoint endpoint = new EndpointSource.Endpoint(path, method);
        if (log.isDebugEnabled()) {
            log.debug(endpoint.toString());
        }
        endpoints.add(endpoint);
    }

    public String findBasePath() {
        String basePath = SwaggerHelper.swagger.getBasePath();
        if (basePath == null) {
            log.warn("No basePath found in Swagger spec. Using empty base path for API.");
            return "";
        }
        while (basePath.endsWith("/")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        return basePath;
    }
}

