/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.swagger;

import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.swagger.ApiNormalisedPath;
import com.networknt.swagger.NormalisedPath;
import com.networknt.swagger.SwaggerHelper;
import com.networknt.swagger.SwaggerOperation;
import com.networknt.utility.ModuleRegistry;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(SwaggerHandler.class);
    public static final String CONFIG_NAME = "swagger";
    static final String STATUS_INVALID_REQUEST_PATH = "ERR10007";
    static final String STATUS_METHOD_NOT_ALLOWED = "ERR10008";
    private volatile HttpHandler next;

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ApiNormalisedPath requestPath = new ApiNormalisedPath(exchange.getRequestURI());
        Optional<NormalisedPath> maybeApiPath = SwaggerHelper.findMatchingApiPath(requestPath);
        if (!maybeApiPath.isPresent()) {
            this.setExchangeStatus(exchange, STATUS_INVALID_REQUEST_PATH, new Object[]{requestPath.normalised()});
            return;
        }
        NormalisedPath swaggerPathString = maybeApiPath.get();
        Path swaggerPath = SwaggerHelper.swagger.getPath(swaggerPathString.original());
        HttpMethod httpMethod = HttpMethod.valueOf((String)exchange.getRequestMethod().toString());
        Operation operation = (Operation)swaggerPath.getOperationMap().get(httpMethod);
        if (operation == null) {
            this.setExchangeStatus(exchange, STATUS_METHOD_NOT_ALLOWED, new Object[0]);
            return;
        }
        SwaggerOperation swaggerOperation = new SwaggerOperation(swaggerPathString, swaggerPath, httpMethod, operation);
        String endpoint = swaggerPathString.normalised() + "@" + httpMethod.toString().toLowerCase();
        HashMap<String, Object> auditInfo = new HashMap<String, Object>();
        auditInfo.put("endpoint", endpoint);
        auditInfo.put("swagger_operation", swaggerOperation);
        exchange.putAttachment(AttachmentConstants.AUDIT_INFO, auditInfo);
        Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return SwaggerHelper.swagger != null;
    }

    public void register() {
        ModuleRegistry.registerModule((String)SwaggerHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfig(CONFIG_NAME), null);
    }
}

