/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.swagger;

import com.networknt.config.Config;
import com.networknt.swagger.ApiNormalisedPath;
import com.networknt.swagger.NormalisedPath;
import io.swagger.models.Swagger;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.parser.SwaggerParser;
import io.swagger.parser.util.SwaggerDeserializationResult;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerHelper {
    static final String SWAGGER_CONFIG = "swagger.json";
    static final Logger logger = LoggerFactory.getLogger(SwaggerHelper.class);
    public static Swagger swagger;
    public static String oauth2Name;

    public static Optional<NormalisedPath> findMatchingApiPath(NormalisedPath requestPath) {
        if (swagger != null) {
            return swagger.getPaths().keySet().stream().map(p -> new ApiNormalisedPath((String)p)).filter(p -> SwaggerHelper.pathMatches(requestPath, p)).findFirst();
        }
        return Optional.empty();
    }

    private static String getOAuth2Name() {
        String name = null;
        Map defMap = swagger.getSecurityDefinitions();
        if (defMap != null) {
            for (Map.Entry entry : defMap.entrySet()) {
                if (!((SecuritySchemeDefinition)entry.getValue()).getType().equals("oauth2")) continue;
                name = (String)entry.getKey();
                break;
            }
        }
        return name;
    }

    private static boolean pathMatches(NormalisedPath requestPath, NormalisedPath apiPath) {
        if (requestPath.parts().size() != apiPath.parts().size()) {
            return false;
        }
        for (int i = 0; i < requestPath.parts().size(); ++i) {
            if (requestPath.part(i).equalsIgnoreCase(apiPath.part(i)) || apiPath.isParam(i)) continue;
            return false;
        }
        return true;
    }

    static {
        SwaggerDeserializationResult swaggerParseResult = new SwaggerParser().readWithInfo(Config.getInstance().getStringFromFile(SWAGGER_CONFIG));
        swagger = swaggerParseResult.getSwagger();
        if (swagger == null) {
            logger.error("Unable to load swagger.json due to " + (String)swaggerParseResult.getMessages().get(0));
            System.out.println("Unable to load swagger.json due to " + (String)swaggerParseResult.getMessages().get(0));
            System.exit(1);
        } else {
            oauth2Name = SwaggerHelper.getOAuth2Name();
        }
    }
}

