/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.validator;

import com.networknt.audit.AuditHandler;
import com.networknt.config.Config;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.status.Status;
import com.networknt.swagger.ApiNormalisedPath;
import com.networknt.swagger.NormalisedPath;
import com.networknt.swagger.SwaggerHelper;
import com.networknt.swagger.SwaggerOperation;
import com.networknt.utility.ModuleRegistry;
import com.networknt.validator.RequestValidator;
import com.networknt.validator.SchemaValidator;
import com.networknt.validator.ValidatorConfig;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorHandler
implements MiddlewareHandler {
    public static final String CONFIG_NAME = "validator";
    static final String STATUS_MISSING_SWAGGER_OPERATION = "ERR10012";
    static final Logger logger = LoggerFactory.getLogger(ValidatorHandler.class);
    static ValidatorConfig config = (ValidatorConfig)Config.getInstance().getJsonObjectConfig("validator", ValidatorConfig.class);
    private volatile HttpHandler next;
    RequestValidator requestValidator;

    public ValidatorHandler() {
        SchemaValidator schemaValidator = new SchemaValidator(SwaggerHelper.swagger);
        this.requestValidator = new RequestValidator(schemaValidator);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ApiNormalisedPath requestPath = new ApiNormalisedPath(exchange.getRequestURI());
        SwaggerOperation swaggerOperation = null;
        Map auditInfo = (Map)exchange.getAttachment(AuditHandler.AUDIT_INFO);
        if (auditInfo != null) {
            swaggerOperation = (SwaggerOperation)auditInfo.get("swagger_operation");
        }
        if (swaggerOperation == null) {
            Status status = new Status(STATUS_MISSING_SWAGGER_OPERATION, new Object[0]);
            exchange.setStatusCode(status.getStatusCode());
            exchange.getResponseSender().send(status.toString());
            return;
        }
        Status status = this.requestValidator.validateRequest((NormalisedPath)requestPath, exchange, swaggerOperation);
        if (status != null) {
            exchange.setStatusCode(status.getStatusCode());
            exchange.getResponseSender().send(status.toString());
            return;
        }
        this.next.handleRequest(exchange);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)ValidatorHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), null);
    }
}

