/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.validator.parameter;

import com.networknt.status.Status;
import com.networknt.validator.parameter.ParameterValidator;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.SerializableParameter;

abstract class BaseParameterValidator
implements ParameterValidator {
    protected BaseParameterValidator() {
    }

    @Override
    public boolean supports(Parameter p) {
        return p != null && p instanceof SerializableParameter && this.supportedParameterType().equalsIgnoreCase(((SerializableParameter)p).getType());
    }

    @Override
    public Status validate(String value, Parameter p) {
        if (!this.supports(p)) {
            return null;
        }
        SerializableParameter parameter = (SerializableParameter)p;
        if (parameter.getRequired() && (value == null || value.trim().isEmpty())) {
            return new Status("ERR11001", new Object[]{p.getName()});
        }
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        if (!this.matchesEnumIfDefined(value, parameter)) {
            return new Status("ERR11002", new Object[]{value, parameter.getName(), parameter.getEnum()});
        }
        return this.doValidate(value, parameter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchesEnumIfDefined(String value, SerializableParameter parameter) {
        if (parameter.getEnum() == null) return true;
        if (parameter.getEnum().isEmpty()) return true;
        if (!parameter.getEnum().stream().anyMatch(value::equals)) return false;
        return true;
    }

    protected abstract Status doValidate(String var1, SerializableParameter var2);
}

