/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.validator;

import com.networknt.status.Status;
import com.networknt.swagger.SwaggerOperation;
import com.networknt.validator.SchemaValidator;
import io.swagger.models.Response;
import io.undertow.server.HttpServerExchange;
import java.util.Objects;

public class ResponseValidator {
    private final SchemaValidator schemaValidator;

    public ResponseValidator(SchemaValidator schemaValidator) {
        this.schemaValidator = Objects.requireNonNull(schemaValidator, "A schema validator is required");
    }

    public Status validateResponse(HttpServerExchange exchange, SwaggerOperation swaggerOperation) {
        Objects.requireNonNull(exchange, "An exchange is required");
        Objects.requireNonNull(swaggerOperation, "A swagger operation is required");
        Response swaggerResponse = (Response)swaggerOperation.getOperation().getResponses().get(Integer.toString(exchange.getStatusCode()));
        if (swaggerResponse == null) {
            swaggerResponse = (Response)swaggerOperation.getOperation().getResponses().get("default");
        }
        if (swaggerResponse == null) {
            return new Status("ERR11015", new Object[]{exchange.getStatusCode(), swaggerOperation.getPathString().original()});
        }
        if (swaggerResponse.getSchema() == null) {
            return null;
        }
        String body = exchange.getOutputStream().toString();
        if (body == null || body.length() == 0) {
            return new Status("ERR11016", new Object[]{swaggerOperation.getMethod(), swaggerOperation.getPathString().original()});
        }
        return this.schemaValidator.validate(body, swaggerResponse.getSchema());
    }
}

