/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.validator.parameter;

import com.networknt.status.Status;
import com.networknt.validator.SchemaValidator;
import com.networknt.validator.parameter.BaseParameterValidator;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.SerializableParameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;

public class ArrayParameterValidator
extends BaseParameterValidator {
    public static final String ARRAY_PARAMETER_TYPE = "array";
    private final SchemaValidator schemaValidator;

    public ArrayParameterValidator(SchemaValidator schemaValidator) {
        this.schemaValidator = schemaValidator == null ? new SchemaValidator() : schemaValidator;
    }

    @Override
    public String supportedParameterType() {
        return ARRAY_PARAMETER_TYPE;
    }

    @Override
    public Status validate(String value, Parameter p) {
        if (!this.supports(p)) {
            return null;
        }
        SerializableParameter parameter = (SerializableParameter)p;
        if (parameter.getRequired() && (value == null || value.trim().isEmpty())) {
            return new Status("ERR11001", new Object[]{parameter.getName()});
        }
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return this.doValidate(value, parameter);
    }

    public Status validate(Collection<String> values, Parameter p) {
        if (p == null) {
            return null;
        }
        SerializableParameter parameter = (SerializableParameter)p;
        if (parameter.getRequired() && (values == null || values.isEmpty())) {
            return new Status("ERR11001", new Object[]{parameter.getName()});
        }
        if (values == null) {
            return null;
        }
        if (!parameter.getCollectionFormat().equalsIgnoreCase(CollectionFormat.MULTI.name())) {
            return new Status("ERR11005", new Object[]{p.getName(), parameter.getCollectionFormat(), "multi"});
        }
        return this.doValidate(values, parameter);
    }

    @Override
    protected Status doValidate(String value, SerializableParameter parameter) {
        return this.doValidate(CollectionFormat.from(parameter).split(value), parameter);
    }

    private Status doValidate(Collection<String> values, SerializableParameter parameter) {
        Optional<Status> optional;
        if (parameter.getMaxItems() != null && values.size() > parameter.getMaxItems()) {
            return new Status("ERR11006", new Object[]{parameter.getName(), parameter.getMaxItems(), values.size()});
        }
        if (parameter.getMinItems() != null && values.size() < parameter.getMinItems()) {
            return new Status("ERR11007", new Object[]{parameter.getName(), parameter.getMinItems(), values.size()});
        }
        if (Boolean.TRUE.equals(parameter.isUniqueItems()) && values.stream().distinct().count() != (long)values.size()) {
            return new Status("ERR11008", new Object[]{parameter.getName()});
        }
        if (parameter.getEnum() != null && !parameter.getEnum().isEmpty()) {
            HashSet enumValues = new HashSet(parameter.getEnum());
            Optional<String> value = values.stream().filter(v -> !enumValues.contains(v)).findFirst();
            if (value.isPresent()) {
                return new Status("ERR11009", new Object[]{value.get(), parameter.getName(), parameter.getEnum()});
            }
        }
        if ((optional = values.stream().map(v -> this.schemaValidator.validate((String)v, parameter.getItems())).filter(s -> s != null).findFirst()).isPresent()) {
            return optional.get();
        }
        return null;
    }

    private static enum CollectionFormat {
        CSV(","),
        SSV(" "),
        TSV("\t"),
        PIPES("\\|"),
        MULTI(null);

        final String separator;

        private CollectionFormat(String separator) {
            this.separator = separator;
        }

        Collection<String> split(String value) {
            if (this.separator == null) {
                return Collections.singleton(value);
            }
            return Arrays.asList(value.split(this.separator));
        }

        static CollectionFormat from(SerializableParameter parameter) {
            Objects.requireNonNull(parameter, "A parameter is required");
            return CollectionFormat.valueOf(parameter.getCollectionFormat().toUpperCase());
        }
    }
}

