/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.validator.parameter;

import com.networknt.status.Status;
import com.networknt.validator.SchemaValidator;
import com.networknt.validator.parameter.ArrayParameterValidator;
import com.networknt.validator.parameter.IntegerParameterValidator;
import com.networknt.validator.parameter.NumberParameterValidator;
import com.networknt.validator.parameter.ParameterValidator;
import com.networknt.validator.parameter.StringParameterValidator;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.SerializableParameter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ParameterValidators {
    private final ArrayParameterValidator arrayValidator;
    private final List<ParameterValidator> validators;

    public ParameterValidators(SchemaValidator schemaValidator) {
        this.arrayValidator = new ArrayParameterValidator(schemaValidator);
        this.validators = Arrays.asList(new StringParameterValidator(), new NumberParameterValidator(), new IntegerParameterValidator());
    }

    public Status validate(String value, Parameter parameter) {
        Objects.requireNonNull(parameter);
        if (parameter instanceof SerializableParameter && ((SerializableParameter)parameter).getType().equalsIgnoreCase("array")) {
            return this.arrayValidator.validate(value, parameter);
        }
        Optional<Status> optional = this.validators.stream().filter(v -> v.supports(parameter)).map(v -> v.validate(value, parameter)).filter(s -> s != null).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }
}

