/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.traceability;

import com.networknt.config.Config;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.traceability.TraceabilityConfig;
import com.networknt.utility.Constants;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceabilityHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(TraceabilityHandler.class);
    public static final String CONFIG_NAME = "traceability";
    public static TraceabilityConfig config = null;
    private volatile HttpHandler next;

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String tid = exchange.getRequestHeaders().getFirst(Constants.TRACEABILITY_ID);
        if (tid != null) {
            exchange.getResponseHeaders().put(Constants.TRACEABILITY_ID, tid);
        }
        this.next.handleRequest(exchange);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)TraceabilityHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), null);
    }

    static {
        config = (TraceabilityConfig)Config.getInstance().getJsonObjectConfig(CONFIG_NAME, TraceabilityConfig.class);
    }
}

