/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client;

import com.networknt.client.AsyncResponse;
import com.networknt.client.AsyncResult;
import com.networknt.client.DefaultAsyncResult;
import com.networknt.client.oauth.ClientCredentialsRequest;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.client.oauth.TokenResponse;
import com.networknt.common.DecryptUtil;
import com.networknt.config.Config;
import com.networknt.exception.ApiException;
import com.networknt.exception.ClientException;
import com.networknt.status.Status;
import com.networknt.utility.Constants;
import com.networknt.utility.ModuleRegistry;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientProvider;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.StringReadChannelListener;
import io.undertow.util.StringWriteChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.ChannelListeners;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

public class Http2Client {
    static final Logger logger;
    public static final String CONFIG_NAME = "client";
    public static final String CONFIG_SECRET = "secret";
    public static final String CONFIG_SECURITY = "security";
    public static final int BUFFER_SIZE = 24576;
    public static final OptionMap DEFAULT_OPTIONS;
    public static final ByteBufferPool POOL;
    public static final ByteBufferPool SSL_BUFFER_POOL;
    public static XnioWorker WORKER;
    public static XnioSsl SSL;
    public static final AttachmentKey<String> RESPONSE_BODY;
    static final String TLS = "tls";
    static final String LOAD_TRUST_STORE = "loadTrustStore";
    static final String LOAD_KEY_STORE = "loadKeyStore";
    static final String TRUST_STORE = "trustStore";
    static final String KEY_STORE = "keyStore";
    static final String TRUST_STORE_PROPERTY = "javax.net.ssl.trustStore";
    static final String TRUST_STORE_PASSWORD_PROPERTY = "javax.net.ssl.trustStorePassword";
    static final String OAUTH = "oauth";
    static final String TOKEN = "token";
    static final String TOKEN_RENEW_BEFORE_EXPIRED = "tokenRenewBeforeExpired";
    static final String EXPIRED_REFRESH_RETRY_DELAY = "expiredRefreshRetryDelay";
    static final String EARLY_REFRESH_RETRY_DELAY = "earlyRefreshRetryDelay";
    static final String OAUTH_HTTP2_SUPPORT = "oauthHttp2Support";
    static final String STATUS_CLIENT_CREDENTIALS_TOKEN_NOT_AVAILABLE = "ERR10009";
    static Map<String, Object> config;
    static Map<String, Object> tokenConfig;
    static Map<String, Object> secretConfig;
    static boolean oauthHttp2Support;
    private String jwt;
    private long expire;
    private volatile boolean renewing = false;
    private volatile long expiredRetryTimeout;
    private volatile long earlyRetryTimeout;
    private final Object lock = new Object();
    private final Map<String, ClientProvider> clientProviders;
    private static final Http2Client INSTANCE;

    private Http2Client() {
        this(Http2Client.class.getClassLoader());
    }

    private Http2Client(ClassLoader classLoader) {
        ServiceLoader<ClientProvider> providers = ServiceLoader.load(ClientProvider.class, classLoader);
        HashMap<String, ClientProvider> map = new HashMap<String, ClientProvider>();
        for (ClientProvider provider : providers) {
            for (String scheme : provider.handlesSchemes()) {
                map.put(scheme, provider);
            }
        }
        this.clientProviders = Collections.unmodifiableMap(map);
        try {
            Xnio xnio = Xnio.getInstance();
            WORKER = xnio.createWorker(null, DEFAULT_OPTIONS);
            SSL = new UndertowXnioSsl(WORKER.getXnio(), OptionMap.EMPTY, SSL_BUFFER_POOL, Http2Client.createSSLContext());
        }
        catch (Exception e) {
            logger.error("Exception: ", e);
        }
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect(uri, worker, null, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect(bindAddress, uri, worker, null, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect((InetSocketAddress)null, uri, worker, ssl, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        final FutureResult result = new FutureResult();
        provider.connect(new ClientCallback<ClientConnection>(){

            @Override
            public void completed(ClientConnection r) {
                result.setResult(r);
            }

            @Override
            public void failed(IOException e) {
                result.setException(e);
            }
        }, bindAddress, uri, worker, ssl, bufferPool, options);
        return result.getIoFuture();
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect((InetSocketAddress)null, uri, ioThread, null, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect(bindAddress, uri, ioThread, null, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect((InetSocketAddress)null, uri, ioThread, ssl, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        final FutureResult result = new FutureResult();
        provider.connect(new ClientCallback<ClientConnection>(){

            @Override
            public void completed(ClientConnection r) {
                result.setResult(r);
            }

            @Override
            public void failed(IOException e) {
                result.setException(e);
            }
        }, bindAddress, uri, ioThread, ssl, bufferPool, options);
        return result.getIoFuture();
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, uri, worker, null, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, bindAddress, uri, worker, null, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, uri, worker, ssl, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, bindAddress, uri, worker, ssl, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, uri, ioThread, null, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, bindAddress, uri, ioThread, null, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, uri, ioThread, ssl, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, bindAddress, uri, ioThread, ssl, bufferPool, options);
    }

    private ClientProvider getClientProvider(URI uri) {
        return this.clientProviders.get(uri.getScheme());
    }

    public static Http2Client getInstance() {
        return INSTANCE;
    }

    public static Http2Client getInstance(ClassLoader classLoader) {
        return new Http2Client(classLoader);
    }

    public void addAuthToken(ClientRequest request, String token) {
        if (token != null && !token.startsWith("Bearer ")) {
            token = token.toUpperCase().startsWith("BEARER ") ? "Bearer " + token.substring(7) : "Bearer " + token;
        }
        request.getRequestHeaders().put(Headers.AUTHORIZATION, token);
    }

    public void addAuthTokenTrace(ClientRequest request, String token, String traceabilityId) {
        if (token != null && !token.startsWith("Bearer ")) {
            token = token.toUpperCase().startsWith("BEARER ") ? "Bearer " + token.substring(7) : "Bearer " + token;
        }
        request.getRequestHeaders().put(Headers.AUTHORIZATION, token);
        request.getRequestHeaders().put(Constants.TRACEABILITY_ID, traceabilityId);
    }

    public void addCcToken(ClientRequest request) throws ClientException, ApiException {
        this.checkCCTokenExpired();
        request.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + this.jwt);
    }

    public void addCcTokenTrace(ClientRequest request, String traceabilityId) throws ClientException, ApiException {
        this.checkCCTokenExpired();
        request.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + this.jwt);
        request.getRequestHeaders().put(Constants.TRACEABILITY_ID, traceabilityId);
    }

    public void propagateHeaders(ClientRequest request, HttpServerExchange exchange) throws ClientException, ApiException {
        String tid = exchange.getRequestHeaders().getFirst(Constants.TRACEABILITY_ID);
        String token = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
        String cid = exchange.getRequestHeaders().getFirst(Constants.CORRELATION_ID);
        this.populateHeader(request, token, cid, tid);
    }

    public void populateHeader(ClientRequest request, String authToken, String correlationId, String traceabilityId) throws ClientException, ApiException {
        if (traceabilityId != null) {
            this.addAuthTokenTrace(request, authToken, traceabilityId);
        } else {
            this.addAuthToken(request, authToken);
        }
        request.getRequestHeaders().put(Constants.CORRELATION_ID, correlationId);
        this.checkCCTokenExpired();
        request.getRequestHeaders().put(Constants.SCOPE_TOKEN, "Bearer " + this.jwt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCCToken() throws ClientException {
        ClientCredentialsRequest tokenRequest = new ClientCredentialsRequest();
        TokenResponse tokenResponse = OauthHelper.getToken(tokenRequest, oauthHttp2Support);
        Object object = this.lock;
        synchronized (object) {
            this.jwt = tokenResponse.getAccessToken();
            this.expire = System.currentTimeMillis() + tokenResponse.getExpiresIn() * 1000L;
            logger.info("Get client credentials token {} with expire_in {} seconds", (Object)this.jwt, (Object)tokenResponse.getExpiresIn());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void checkCCTokenExpired() throws ClientException, ApiException {
        long tokenRenewBeforeExpired = ((Integer)tokenConfig.get(TOKEN_RENEW_BEFORE_EXPIRED)).intValue();
        long expiredRefreshRetryDelay = ((Integer)tokenConfig.get(EXPIRED_REFRESH_RETRY_DELAY)).intValue();
        long earlyRefreshRetryDelay = ((Integer)tokenConfig.get(EARLY_REFRESH_RETRY_DELAY)).intValue();
        boolean isInRenewWindow = this.expire - System.currentTimeMillis() < tokenRenewBeforeExpired;
        logger.trace("isInRenewWindow = " + isInRenewWindow);
        if (isInRenewWindow) {
            if (this.expire <= System.currentTimeMillis()) {
                logger.trace("In renew window and token is expired.");
                Class<Http2Client> clazz = Http2Client.class;
                // MONITORENTER : com.networknt.client.Http2Client.class
                if (this.expire <= System.currentTimeMillis()) {
                    logger.trace("Within the synch block, check if the current request need to renew token");
                    if (this.renewing && System.currentTimeMillis() <= this.expiredRetryTimeout) {
                        logger.trace("Circuit breaker is tripped and not timeout yet!");
                        throw new ApiException(new Status(STATUS_CLIENT_CREDENTIALS_TOKEN_NOT_AVAILABLE, new Object[0]));
                    }
                    this.renewing = true;
                    this.expiredRetryTimeout = System.currentTimeMillis() + expiredRefreshRetryDelay;
                    logger.trace("Current request is renewing token synchronously as token is expired already");
                    this.getCCToken();
                    this.renewing = false;
                }
                // MONITOREXIT : clazz
            } else {
                logger.trace("In renew window but token is not expired yet.");
                Class<Http2Client> clazz = Http2Client.class;
                // MONITORENTER : com.networknt.client.Http2Client.class
                if (!(this.expire <= System.currentTimeMillis() || this.renewing && System.currentTimeMillis() <= this.earlyRetryTimeout)) {
                    this.renewing = true;
                    this.earlyRetryTimeout = System.currentTimeMillis() + earlyRefreshRetryDelay;
                    logger.trace("Retrieve token async is called while token is not expired yet");
                    ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
                    executor.schedule(() -> {
                        try {
                            this.getCCToken();
                            this.renewing = false;
                            logger.trace("Async get token is completed.");
                        }
                        catch (Exception e) {
                            logger.error("Async retrieve token error", e);
                        }
                    }, 50L, TimeUnit.MILLISECONDS);
                    executor.shutdown();
                }
                // MONITOREXIT : clazz
            }
        }
        logger.trace("Check secondary token is done!");
    }

    private static KeyStore loadKeyStore(String name, char[] password) throws IOException {
        InputStream stream = Config.getInstance().getInputStreamFromFile(name);
        if (stream == null) {
            throw new RuntimeException("Could not load keystore");
        }
        try {
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(stream, password);
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IOException(String.format("Unable to load KeyStore %s", name), e);
        }
        finally {
            IoUtils.safeClose((Closeable)stream);
        }
    }

    public static SSLContext createSSLContext() throws IOException {
        SSLContext sslContext = null;
        KeyManager[] keyManagers = null;
        Map tlsMap = (Map)config.get(TLS);
        if (tlsMap != null) {
            try {
                Boolean loadKeyStore = (Boolean)tlsMap.get(LOAD_KEY_STORE);
                if (loadKeyStore != null && loadKeyStore.booleanValue()) {
                    String keyStoreName = (String)tlsMap.get(KEY_STORE);
                    String keyStorePass = (String)secretConfig.get("clientKeystorePass");
                    String keyPass = (String)secretConfig.get("clientKeyPass");
                    KeyStore keyStore = Http2Client.loadKeyStore(keyStoreName, keyStorePass.toCharArray());
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    keyManagerFactory.init(keyStore, keyPass.toCharArray());
                    keyManagers = keyManagerFactory.getKeyManagers();
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new IOException("Unable to initialise KeyManager[]", e);
            }
            TrustManager[] trustManagers = null;
            try {
                Boolean loadTrustStore = (Boolean)tlsMap.get(LOAD_TRUST_STORE);
                if (loadTrustStore != null && loadTrustStore.booleanValue()) {
                    String trustStoreName = System.getProperty(TRUST_STORE_PROPERTY);
                    String trustStorePass = System.getProperty(TRUST_STORE_PASSWORD_PROPERTY);
                    if (trustStoreName != null && trustStorePass != null) {
                        logger.info("Loading trust store from system property at " + Encode.forJava(trustStoreName));
                    } else {
                        trustStoreName = (String)tlsMap.get(TRUST_STORE);
                        trustStorePass = (String)secretConfig.get("clientTruststorePass");
                        logger.info("Loading trust store from config at " + Encode.forJava(trustStoreName));
                    }
                    if (trustStoreName != null && trustStorePass != null) {
                        KeyStore trustStore = Http2Client.loadKeyStore(trustStoreName, trustStorePass.toCharArray());
                        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        trustManagerFactory.init(trustStore);
                        trustManagers = trustManagerFactory.getTrustManagers();
                    }
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                throw new IOException("Unable to initialise TrustManager[]", e);
            }
            try {
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(keyManagers, trustManagers, null);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IOException("Unable to create and initialise the SSLContext", e);
            }
        }
        logger.error("TLS configuration section is missing in client.yml");
        return sslContext;
    }

    public static String getFormDataString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return result.toString();
    }

    public ClientCallback<ClientExchange> createClientCallback(final AtomicReference<ClientResponse> reference, final CountDownLatch latch) {
        return new ClientCallback<ClientExchange>(){

            @Override
            public void completed(ClientExchange result) {
                result.setResponseListener(new ClientCallback<ClientExchange>(){

                    @Override
                    public void completed(final ClientExchange result) {
                        reference.set(result.getResponse());
                        new StringReadChannelListener(result.getConnection().getBufferPool()){

                            @Override
                            protected void stringDone(String string) {
                                result.getResponse().putAttachment(RESPONSE_BODY, string);
                                latch.countDown();
                            }

                            @Override
                            protected void error(IOException e) {
                                logger.error("IOException:", e);
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    @Override
                    public void failed(IOException e) {
                        logger.error("IOException:", e);
                        latch.countDown();
                    }
                });
                try {
                    result.getRequestChannel().shutdownWrites();
                    if (!result.getRequestChannel().flush()) {
                        result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        result.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException e) {
                    logger.error("IOException:", e);
                    latch.countDown();
                }
            }

            @Override
            public void failed(IOException e) {
                logger.error("IOException:", e);
                latch.countDown();
            }
        };
    }

    public ClientCallback<ClientExchange> createClientCallback(final AtomicReference<ClientResponse> reference, final CountDownLatch latch, final String requestBody) {
        return new ClientCallback<ClientExchange>(){

            @Override
            public void completed(ClientExchange result) {
                new StringWriteChannelListener(requestBody).setup(result.getRequestChannel());
                result.setResponseListener(new ClientCallback<ClientExchange>(){

                    @Override
                    public void completed(final ClientExchange result) {
                        reference.set(result.getResponse());
                        new StringReadChannelListener(POOL){

                            @Override
                            protected void stringDone(String string) {
                                result.getResponse().putAttachment(RESPONSE_BODY, string);
                                latch.countDown();
                            }

                            @Override
                            protected void error(IOException e) {
                                logger.error("IOException:", e);
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    @Override
                    public void failed(IOException e) {
                        logger.error("IOException:", e);
                        latch.countDown();
                    }
                });
            }

            @Override
            public void failed(IOException e) {
                logger.error("IOException:", e);
                latch.countDown();
            }
        };
    }

    public ClientCallback<ClientExchange> createFullCallback(final AtomicReference<AsyncResult<AsyncResponse>> reference, final CountDownLatch latch) {
        final long startTime = System.currentTimeMillis();
        return new ClientCallback<ClientExchange>(){

            @Override
            public void completed(ClientExchange result) {
                result.setResponseListener(new ClientCallback<ClientExchange>(){

                    @Override
                    public void completed(final ClientExchange result) {
                        new StringReadChannelListener(result.getConnection().getBufferPool()){

                            @Override
                            protected void stringDone(String string) {
                                AsyncResponse ar = new AsyncResponse(result.getResponse(), string, System.currentTimeMillis() - startTime);
                                reference.set(DefaultAsyncResult.succeed(ar));
                                latch.countDown();
                            }

                            @Override
                            protected void error(IOException e) {
                                reference.set(DefaultAsyncResult.fail(e));
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    @Override
                    public void failed(IOException e) {
                        reference.set(DefaultAsyncResult.fail(e));
                        latch.countDown();
                    }
                });
                try {
                    result.getRequestChannel().shutdownWrites();
                    if (!result.getRequestChannel().flush()) {
                        result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        result.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException e) {
                    reference.set(DefaultAsyncResult.fail(e));
                    latch.countDown();
                }
            }

            @Override
            public void failed(IOException e) {
                reference.set(DefaultAsyncResult.fail(e));
                latch.countDown();
            }
        };
    }

    public ClientCallback<ClientExchange> createFullCallback(final AtomicReference<AsyncResult<AsyncResponse>> reference, final CountDownLatch latch, final String requestBody) {
        final long startTime = System.currentTimeMillis();
        return new ClientCallback<ClientExchange>(){

            @Override
            public void completed(ClientExchange result) {
                new StringWriteChannelListener(requestBody).setup(result.getRequestChannel());
                result.setResponseListener(new ClientCallback<ClientExchange>(){

                    @Override
                    public void completed(final ClientExchange result) {
                        new StringReadChannelListener(POOL){

                            @Override
                            protected void stringDone(String string) {
                                AsyncResponse ar = new AsyncResponse(result.getResponse(), string, System.currentTimeMillis() - startTime);
                                reference.set(DefaultAsyncResult.succeed(ar));
                                latch.countDown();
                            }

                            @Override
                            protected void error(IOException e) {
                                reference.set(DefaultAsyncResult.fail(e));
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    @Override
                    public void failed(IOException e) {
                        reference.set(DefaultAsyncResult.fail(e));
                        latch.countDown();
                    }
                });
            }

            @Override
            public void failed(IOException e) {
                reference.set(DefaultAsyncResult.fail(e));
                latch.countDown();
            }
        };
    }

    static {
        Map<String, Object> secretMap;
        Map<String, Object> securityConfig;
        Map oauthConfig;
        logger = LoggerFactory.getLogger(Http2Client.class);
        DEFAULT_OPTIONS = OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.TCP_NODELAY, true).set(Options.KEEP_ALIVE, true).set(Options.WORKER_NAME, "Client").getMap();
        POOL = new DefaultByteBufferPool(true, 24576, 1000, 10, 100);
        SSL_BUFFER_POOL = new DefaultByteBufferPool(true, 17408);
        RESPONSE_BODY = AttachmentKey.create(String.class);
        ArrayList<String> masks = new ArrayList<String>();
        ModuleRegistry.registerModule(Http2Client.class.getName(), Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), masks);
        config = Config.getInstance().getJsonMapConfig(CONFIG_NAME);
        if (config != null && (oauthConfig = (Map)config.get(OAUTH)) != null) {
            tokenConfig = (Map)oauthConfig.get(TOKEN);
        }
        if ((securityConfig = Config.getInstance().getJsonMapConfig(CONFIG_SECURITY)) != null) {
            Boolean b = (Boolean)securityConfig.get(OAUTH_HTTP2_SUPPORT);
            boolean bl = oauthHttp2Support = b == null ? false : b;
        }
        if ((secretMap = Config.getInstance().getJsonMapConfig(CONFIG_SECRET)) == null) {
            throw new ExceptionInInitializerError("Could not locate secret.yml");
        }
        secretConfig = DecryptUtil.decryptMap(secretMap);
        INSTANCE = new Http2Client();
    }
}

