/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.common.DecryptUtil;
import com.networknt.config.Config;
import java.util.Map;

public class KeyRequest {
    public static String OAUTH = "oauth";
    public static String KEY = "key";
    public static String SERVER_URL = "server_url";
    public static String URI = "uri";
    public static String CLIENT_ID = "client_id";
    static Map<String, Object> secret = DecryptUtil.decryptMap(Config.getInstance().getJsonMapConfig("secret"));
    String serverUrl;
    String uri;
    String clientId;
    String clientSecret;

    public KeyRequest(String kid) {
        Map keyConfig;
        Map oauthConfig;
        Map<String, Object> clientConfig = Config.getInstance().getJsonMapConfig("client");
        if (clientConfig != null && (oauthConfig = (Map)clientConfig.get(OAUTH)) != null && (keyConfig = (Map)oauthConfig.get(KEY)) != null) {
            this.setServerUrl((String)keyConfig.get(SERVER_URL));
            this.setUri(keyConfig.get(URI) + "/" + kid);
            this.setClientId((String)keyConfig.get(CLIENT_ID));
            this.setClientSecret((String)secret.get("keyClientSecret"));
        }
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }
}

