/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.client.Http2Client;
import com.networknt.client.oauth.AuthorizationCodeRequest;
import com.networknt.client.oauth.KeyRequest;
import com.networknt.client.oauth.TokenRequest;
import com.networknt.client.oauth.TokenResponse;
import com.networknt.config.Config;
import com.networknt.exception.ClientException;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.StringReadChannelListener;
import io.undertow.util.StringWriteChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class OauthHelper {
    static final String BASIC = "Basic";
    static final String GRANT_TYPE = "grant_type";
    static final String CODE = "code";
    static final Logger logger = LoggerFactory.getLogger(OauthHelper.class);

    public static TokenResponse getToken(final TokenRequest tokenRequest, boolean http2) throws ClientException {
        ClientConnection connection;
        final AtomicReference reference = new AtomicReference();
        Http2Client client = Http2Client.getInstance();
        final CountDownLatch latch = new CountDownLatch(1);
        try {
            connection = client.connect(new URI(tokenRequest.getServerUrl()), Http2Client.WORKER, Http2Client.SSL, Http2Client.POOL, http2 ? OptionMap.create(UndertowOptions.ENABLE_HTTP2, true) : OptionMap.EMPTY).get();
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        try {
            final String requestBody = OauthHelper.getEncodedString(tokenRequest);
            connection.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    ClientRequest request = new ClientRequest().setMethod(Methods.POST).setPath(tokenRequest.getUri());
                    request.getRequestHeaders().put(Headers.HOST, "localhost");
                    request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, "chunked");
                    request.getRequestHeaders().put(Headers.CONTENT_TYPE, "application/x-www-form-urlencoded");
                    request.getRequestHeaders().put(Headers.AUTHORIZATION, OauthHelper.getBasicAuthHeader(tokenRequest.getClientId(), tokenRequest.getClientSecret()));
                    connection.sendRequest(request, new ClientCallback<ClientExchange>(){

                        @Override
                        public void completed(ClientExchange result) {
                            new StringWriteChannelListener(requestBody).setup(result.getRequestChannel());
                            result.setResponseListener(new ClientCallback<ClientExchange>(){

                                @Override
                                public void completed(ClientExchange result) {
                                    new StringReadChannelListener(Http2Client.POOL){

                                        @Override
                                        protected void stringDone(String string) {
                                            logger.debug("getToken response = " + string);
                                            reference.set(OauthHelper.handleResponse(string));
                                            latch.countDown();
                                        }

                                        @Override
                                        protected void error(IOException e) {
                                            logger.error("IOException:", e);
                                            latch.countDown();
                                        }
                                    }.setup(result.getResponseChannel());
                                }

                                @Override
                                public void failed(IOException e) {
                                    logger.error("IOException:", e);
                                    latch.countDown();
                                }
                            });
                        }

                        @Override
                        public void failed(IOException e) {
                            logger.error("IOException:", e);
                            latch.countDown();
                        }
                    });
                }
            });
            latch.await(4L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("IOException: ", e);
            throw new ClientException(e);
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
        return (TokenResponse)reference.get();
    }

    public static String getKey(KeyRequest keyRequest, boolean http2) throws ClientException {
        ClientConnection connection;
        Http2Client client = Http2Client.getInstance();
        CountDownLatch latch = new CountDownLatch(1);
        try {
            connection = client.connect(new URI(keyRequest.getServerUrl()), Http2Client.WORKER, Http2Client.SSL, Http2Client.POOL, http2 ? OptionMap.create(UndertowOptions.ENABLE_HTTP2, true) : OptionMap.EMPTY).get();
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
        try {
            ClientRequest request = new ClientRequest().setPath(keyRequest.getUri()).setMethod(Methods.GET);
            request.getRequestHeaders().put(Headers.AUTHORIZATION, OauthHelper.getBasicAuthHeader(keyRequest.getClientId(), keyRequest.getClientSecret()));
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            connection.sendRequest(request, client.createClientCallback(reference, latch));
            latch.await();
        }
        catch (Exception e) {
            logger.error("Exception: ", e);
            throw new ClientException(e);
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
        return reference.get().getAttachment(Http2Client.RESPONSE_BODY);
    }

    public static String getBasicAuthHeader(String clientId, String clientSecret) {
        return "Basic " + OauthHelper.encodeCredentials(clientId, clientSecret);
    }

    public static String encodeCredentials(String clientId, String clientSecret) {
        String cred = clientSecret != null ? clientId + ":" + clientSecret : clientId;
        byte[] encodedBytes = Base64.encodeBase64(cred.getBytes(StandardCharsets.UTF_8));
        String encodedValue = new String(encodedBytes, StandardCharsets.UTF_8);
        return encodedValue;
    }

    private static String getEncodedString(TokenRequest request) throws UnsupportedEncodingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(GRANT_TYPE, request.getGrantType());
        if (TokenRequest.AUTHORIZATION_CODE.equals(request.getGrantType())) {
            params.put(CODE, ((AuthorizationCodeRequest)request).getAuthCode());
            params.put(TokenRequest.REDIRECT_URI, ((AuthorizationCodeRequest)request).getRedirectUri());
        }
        if (request.getScope() != null) {
            params.put(TokenRequest.SCOPE, StringUtils.join(request.getScope(), " "));
        }
        return Http2Client.getFormDataString(params);
    }

    private static TokenResponse handleResponse(String responseBody) {
        TokenResponse tokenResponse = null;
        try {
            if (responseBody != null && responseBody.length() > 0) {
                tokenResponse = Config.getInstance().getMapper().readValue(responseBody, TokenResponse.class);
            } else {
                logger.error("Error in token retrieval, response = " + Encode.forJava(responseBody));
            }
        }
        catch (IOException | RuntimeException e) {
            logger.error("Error in token retrieval", e);
        }
        return tokenResponse;
    }
}

