/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.cdc.mysql.binlog;

import com.networknt.eventuate.cdc.mysql.binlog.DatabaseBinlogOffsetKafkaStore;
import com.networknt.eventuate.cdc.mysql.binlog.DuplicatePublishingDetector;
import com.networknt.eventuate.server.common.BinLogEvent;
import com.networknt.eventuate.server.common.CdcKafkaPublisher;
import com.networknt.eventuate.server.common.PublishingStrategy;
import com.networknt.eventuate.server.common.exception.EventuateLocalPublishingException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLCdcKafkaPublisher<EVENT extends BinLogEvent>
extends CdcKafkaPublisher<EVENT> {
    private DatabaseBinlogOffsetKafkaStore binlogOffsetKafkaStore;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private DuplicatePublishingDetector duplicatePublishingDetector;

    public MySQLCdcKafkaPublisher(DatabaseBinlogOffsetKafkaStore binlogOffsetKafkaStore, String kafkaBootstrapServers, PublishingStrategy<EVENT> publishingStrategy) {
        super(publishingStrategy);
        this.binlogOffsetKafkaStore = binlogOffsetKafkaStore;
        this.duplicatePublishingDetector = new DuplicatePublishingDetector();
    }

    @Override
    public void handleEvent(EVENT publishedEvent) throws EventuateLocalPublishingException {
        this.logger.trace("Got record " + publishedEvent.toString());
        String aggregateTopic = this.publishingStrategy.topicFor(publishedEvent);
        String json = this.publishingStrategy.toJson(publishedEvent);
        Exception lastException = null;
        for (int i = 0; i < 5; ++i) {
            try {
                if (this.duplicatePublishingDetector.shouldBePublished(publishedEvent.getBinlogFileOffset(), aggregateTopic)) {
                    this.producer.send(aggregateTopic, this.publishingStrategy.partitionKeyFor(publishedEvent), json).get(10L, TimeUnit.SECONDS);
                    this.binlogOffsetKafkaStore.save(publishedEvent.getBinlogFileOffset());
                } else {
                    this.logger.debug("Duplicate event {}", (Object)publishedEvent);
                }
                return;
            }
            catch (Exception e) {
                this.logger.warn("error publishing to " + aggregateTopic, e);
                lastException = e;
                try {
                    Thread.sleep((int)Math.pow(2.0, i) * 1000);
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
            }
        }
        throw new EventuateLocalPublishingException("error publishing to " + aggregateTopic, lastException);
    }
}

