/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.cdc.mysql.binlog;

import com.github.shyiko.mysql.binlog.event.WriteRowsEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.json.JsonBinary;
import com.networknt.eventuate.cdc.mysql.binlog.IWriteRowsEventDataParser;
import com.networknt.eventuate.jdbc.EventuateSchema;
import com.networknt.eventuate.server.common.BinlogFileOffset;
import com.networknt.eventuate.server.common.PublishedEvent;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;

public class WriteRowsEventDataParser
implements IWriteRowsEventDataParser<PublishedEvent> {
    private DataSource dataSource;
    private final String sourceTableName;
    private static final String EVENT_ID_FIELDNAME = "event_id";
    private static final String EVENT_TYPE_FIELDNAME = "event_type";
    private static final String EVENT_DATA_FIELDNAME = "event_data";
    private static final String ENTITY_ID_FIELDNAME = "entity_id";
    private static final String ENTITY_TYPE_FIELDNAME = "entity_type";
    private static final String EVENT_METADATA_FIELDNAME = "metadata";
    private Map<String, Integer> columnOrders = new HashMap<String, Integer>();
    private EventuateSchema eventuateSchema;

    public WriteRowsEventDataParser(DataSource dataSource, String sourceTableName, EventuateSchema eventuateSchema) {
        this.dataSource = dataSource;
        this.sourceTableName = sourceTableName;
        this.eventuateSchema = eventuateSchema;
    }

    @Override
    public PublishedEvent parseEventData(WriteRowsEventData eventData, String binlogFilename, long position) throws IOException {
        if (this.columnOrders.isEmpty()) {
            try {
                this.getColumnOrders();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        String eventDataValue = this.getValue(eventData, EVENT_DATA_FIELDNAME) instanceof String ? (String)((Object)this.getValue(eventData, EVENT_DATA_FIELDNAME)) : JsonBinary.parseAsString((byte[])this.getValue(eventData, EVENT_DATA_FIELDNAME));
        return new PublishedEvent((String)((Object)this.getValue(eventData, EVENT_ID_FIELDNAME)), (String)((Object)this.getValue(eventData, ENTITY_ID_FIELDNAME)), (String)((Object)this.getValue(eventData, ENTITY_TYPE_FIELDNAME)), eventDataValue, (String)((Object)this.getValue(eventData, EVENT_TYPE_FIELDNAME)), new BinlogFileOffset(binlogFilename, position), Optional.ofNullable((String)((Object)this.getValue(eventData, EVENT_METADATA_FIELDNAME))));
    }

    private Serializable getValue(WriteRowsEventData eventData, String columnName) {
        if (this.columnOrders.containsKey(columnName)) {
            return eventData.getRows().get(0)[this.columnOrders.get(columnName) - 1];
        }
        throw new RuntimeException("Column with name [" + columnName + "] not found");
    }

    private void getColumnOrders() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet columnResultSet = metaData.getColumns(this.eventuateSchema.isEmpty() ? null : this.eventuateSchema.getEventuateDatabaseSchema(), "public", this.sourceTableName.toLowerCase(), null);){
                while (columnResultSet.next()) {
                    this.columnOrders.put(columnResultSet.getString("COLUMN_NAME").toLowerCase(), columnResultSet.getInt("ORDINAL_POSITION"));
                }
            }
        }
    }
}

