/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.common;

import com.networknt.eventuate.common.Aggregate;
import com.networknt.eventuate.common.AggregateRepositoryInterceptor;
import com.networknt.eventuate.common.Aggregates;
import com.networknt.eventuate.common.Command;
import com.networknt.eventuate.common.CommandProcessingAggregate;
import com.networknt.eventuate.common.CompletableFutureUtil;
import com.networknt.eventuate.common.DefaultAggregateRepositoryInterceptor;
import com.networknt.eventuate.common.DefaultMissingApplyEventMethodStrategy;
import com.networknt.eventuate.common.DuplicateTriggeringEventException;
import com.networknt.eventuate.common.EntityIdAndVersion;
import com.networknt.eventuate.common.EntityWithIdAndVersion;
import com.networknt.eventuate.common.EntityWithMetadata;
import com.networknt.eventuate.common.Event;
import com.networknt.eventuate.common.EventWithMetadata;
import com.networknt.eventuate.common.EventuateAggregateStore;
import com.networknt.eventuate.common.EventuateCommandProcessingFailedException;
import com.networknt.eventuate.common.FindOptions;
import com.networknt.eventuate.common.Int128;
import com.networknt.eventuate.common.MissingApplyEventMethodStrategy;
import com.networknt.eventuate.common.OptimisticLockingException;
import com.networknt.eventuate.common.SaveOptions;
import com.networknt.eventuate.common.Snapshot;
import com.networknt.eventuate.common.UpdateEventsAndOptions;
import com.networknt.eventuate.common.UpdateOptions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateRepository<T extends CommandProcessingAggregate<T, CT>, CT extends Command> {
    private static Logger logger = LoggerFactory.getLogger(AggregateRepository.class);
    private Class<T> clasz;
    private EventuateAggregateStore aggregateStore;
    private AggregateRepositoryInterceptor<T, CT> interceptor = new DefaultAggregateRepositoryInterceptor();
    private MissingApplyEventMethodStrategy missingApplyEventMethodStrategy = new DefaultMissingApplyEventMethodStrategy();

    public AggregateRepository(Class<T> clasz, EventuateAggregateStore aggregateStore) {
        this.clasz = clasz;
        this.aggregateStore = aggregateStore;
    }

    public void setMissingApplyEventMethodStrategy(MissingApplyEventMethodStrategy missingApplyEventMethodStrategy) {
        this.missingApplyEventMethodStrategy = missingApplyEventMethodStrategy;
    }

    public void setInterceptor(AggregateRepositoryInterceptor<T, CT> interceptor) {
        this.interceptor = interceptor;
    }

    public CompletableFuture<EntityWithIdAndVersion<T>> save(CT cmd) {
        return this.save(cmd, Optional.empty());
    }

    public CompletableFuture<EntityWithIdAndVersion<T>> save(CT cmd, Optional<SaveOptions> saveOptions) {
        CommandProcessingAggregate aggregate;
        try {
            aggregate = (CommandProcessingAggregate)this.clasz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        List<Event> events = aggregate.processCommand(cmd);
        Aggregates.applyEventsToMutableAggregate(aggregate, events, this.missingApplyEventMethodStrategy);
        return this.aggregateStore.save(this.clasz, events, saveOptions).thenApply(entityIdAndVersion -> new EntityWithIdAndVersion<CommandProcessingAggregate>((EntityIdAndVersion)entityIdAndVersion, aggregate));
    }

    public CompletableFuture<EntityWithIdAndVersion<T>> update(String entityId, CT cmd) {
        return this.update(entityId, cmd, Optional.empty());
    }

    private <T> CompletableFuture<T> withRetry(Supplier<CompletableFuture<T>> asyncRequest) {
        CompletableFuture result = new CompletableFuture();
        this.attemptOperation(asyncRequest, result, 0);
        return result;
    }

    private <T> void attemptOperation(Supplier<CompletableFuture<T>> asyncRequest, CompletableFuture<T> result, int attempt) {
        CompletableFuture<T> f = asyncRequest.get();
        f.handleAsync((val, throwable) -> {
            if (throwable != null) {
                if (attempt < 10 && CompletableFutureUtil.unwrap(throwable) instanceof OptimisticLockingException) {
                    logger.debug("got optimistic locking exception - retrying", (Throwable)throwable);
                    this.attemptOperation(asyncRequest, result, attempt + 1);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("got exception - NOT retrying: " + attempt, (Throwable)throwable);
                    }
                    result.completeExceptionally((Throwable)throwable);
                }
            } else {
                result.complete(val);
            }
            return null;
        });
    }

    public CompletableFuture<EntityWithIdAndVersion<T>> update(String entityId, CT cmd, Optional<UpdateOptions> updateOptions) {
        return this.updateWithProvidedCommand(entityId, a -> Optional.of(cmd), updateOptions);
    }

    public CompletableFuture<EntityWithIdAndVersion<T>> updateWithProvidedCommand(String entityId, Function<T, Optional<CT>> commandProvider, Optional<UpdateOptions> updateOptions) {
        return this.withRetry(() -> {
            CompletionStage eo = this.aggregateStore.find(this.clasz, entityId, updateOptions.map(uo -> new FindOptions().withTriggeringEvent(uo.getTriggeringEvent()))).handleAsync((tEntityWithMetadata, throwable) -> {
                if (throwable == null) {
                    return new LoadedEntityWithMetadata(true, tEntityWithMetadata);
                }
                logger.debug("Exception finding aggregate", (Throwable)throwable);
                Throwable unwrapped = CompletableFutureUtil.unwrap(throwable);
                if (unwrapped instanceof DuplicateTriggeringEventException) {
                    return new LoadedEntityWithMetadata(false, null);
                }
                if (unwrapped instanceof RuntimeException) {
                    throw (RuntimeException)unwrapped;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new RuntimeException((Throwable)throwable);
            });
            return ((CompletableFuture)eo).thenCompose(loadedEntityWithMetadata -> {
                UpdateEventsAndOptions transformed;
                if (!loadedEntityWithMetadata.success) return this.aggregateStore.find(this.clasz, entityId, Optional.empty()).thenApply(EntityWithMetadata::toEntityWithIdAndVersion);
                EntityWithMetadata entityWithMetaData = loadedEntityWithMetadata.ewmd;
                CommandProcessingAggregate aggregate = (CommandProcessingAggregate)entityWithMetaData.getEntity();
                Outcome commandResult = ((Optional)commandProvider.apply(aggregate)).map(command -> {
                    try {
                        return new Outcome<List<Event>>(aggregate.processCommand(command));
                    }
                    catch (EventuateCommandProcessingFailedException e) {
                        return new Outcome(e.getCause());
                    }
                }).orElse(new Outcome(Collections.emptyList()));
                if (commandResult.isFailure()) {
                    Optional<UpdateEventsAndOptions> handled = this.interceptor.handleException(aggregate, commandResult.throwable, updateOptions);
                    if (!handled.isPresent()) throw new EventuateCommandProcessingFailedException(commandResult.throwable);
                    transformed = handled.get();
                } else {
                    List events = (List)commandResult.result;
                    Aggregates.applyEventsToMutableAggregate(aggregate, events, this.missingApplyEventMethodStrategy);
                    UpdateEventsAndOptions original = new UpdateEventsAndOptions(events, updateOptions);
                    transformed = updateOptions.flatMap(uo -> uo.getInterceptor()).orElse(this.interceptor).transformUpdate(aggregate, original);
                }
                List<Event> transformedEvents = transformed.getEvents();
                Optional<UpdateOptions> transformedOptions = transformed.getOptions();
                if (transformedEvents.isEmpty()) {
                    return CompletableFuture.completedFuture(entityWithMetaData.toEntityWithIdAndVersion());
                }
                CompletableFuture result = new CompletableFuture();
                ((CompletableFuture)this.aggregateStore.update(this.clasz, entityWithMetaData.getEntityIdAndVersion(), transformedEvents, this.withPossibleSnapshot(transformedOptions, aggregate, entityWithMetaData.getSnapshotVersion(), loadedEntityWithMetadata.ewmd.getEvents(), transformedEvents)).thenApply(entityIdAndVersion -> new EntityWithIdAndVersion<CommandProcessingAggregate>((EntityIdAndVersion)entityIdAndVersion, aggregate))).handle((r, t) -> {
                    if (t == null) {
                        result.complete(r);
                    } else {
                        logger.debug("Exception updating aggregate", (Throwable)t);
                        Throwable unwrapped = CompletableFutureUtil.unwrap(t);
                        if (unwrapped instanceof DuplicateTriggeringEventException) {
                            this.aggregateStore.find(this.clasz, entityId, Optional.empty()).handle((reloadedAggregate, findException) -> {
                                if (findException == null) {
                                    result.complete(new EntityWithIdAndVersion(reloadedAggregate.getEntityIdAndVersion(), reloadedAggregate.getEntity()));
                                } else {
                                    result.completeExceptionally((Throwable)findException);
                                }
                                return null;
                            });
                        } else {
                            result.completeExceptionally(unwrapped);
                        }
                    }
                    return null;
                });
                return result;
            });
        });
    }

    private Optional<UpdateOptions> withPossibleSnapshot(Optional<UpdateOptions> updateOptions, T aggregate, Optional<Int128> snapshotVersion, List<EventWithMetadata> oldEvents, List<Event> newEvents) {
        Optional optionsWithSnapshot = this.aggregateStore.possiblySnapshot((Aggregate)aggregate, snapshotVersion, oldEvents, newEvents).flatMap(snapshot -> Optional.of(updateOptions.orElse(new UpdateOptions()).withSnapshot((Snapshot)snapshot)));
        return optionsWithSnapshot.isPresent() ? optionsWithSnapshot : updateOptions;
    }

    public CompletableFuture<EntityWithMetadata<T>> find(String entityId) {
        return this.aggregateStore.find(this.clasz, entityId);
    }

    public CompletableFuture<EntityWithMetadata<T>> find(String entityId, FindOptions findOptions) {
        return this.aggregateStore.find(this.clasz, entityId, findOptions);
    }

    public CompletableFuture<EntityWithMetadata<T>> find(String entityId, Optional<FindOptions> findOptions) {
        return this.aggregateStore.find(this.clasz, entityId, findOptions);
    }

    class Outcome<T> {
        public final T result;
        public final Throwable throwable;

        public Outcome(T result) {
            this.result = result;
            this.throwable = null;
        }

        public Outcome(Throwable throwable) {
            this.result = null;
            this.throwable = throwable;
        }

        public boolean isFailure() {
            return this.throwable != null;
        }
    }

    class LoadedEntityWithMetadata {
        boolean success;
        EntityWithMetadata<T> ewmd;

        LoadedEntityWithMetadata(boolean success, EntityWithMetadata<T> ewmd) {
            this.success = success;
            this.ewmd = ewmd;
        }
    }
}

