/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.common;

import com.networknt.eventuate.common.AggregateRepositoryInterceptor;
import com.networknt.eventuate.common.EventContext;
import com.networknt.eventuate.common.Snapshot;
import java.util.Map;
import java.util.Optional;

public class UpdateOptions {
    private final Optional<EventContext> triggeringEvent;
    private final Optional<Map<String, String>> eventMetadata;
    private final Optional<Snapshot> snapshot;
    private final Optional<AggregateRepositoryInterceptor> interceptor;

    public UpdateOptions() {
        this.triggeringEvent = Optional.empty();
        this.eventMetadata = Optional.empty();
        this.snapshot = Optional.empty();
        this.interceptor = Optional.empty();
    }

    public UpdateOptions(Optional<EventContext> triggeringEvent, Optional<Map<String, String>> eventMetadata, Optional<Snapshot> snapshot, Optional<AggregateRepositoryInterceptor> interceptor) {
        this.triggeringEvent = triggeringEvent;
        this.eventMetadata = eventMetadata;
        this.snapshot = snapshot;
        this.interceptor = interceptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateOptions that = (UpdateOptions)o;
        return this.triggeringEvent != null ? this.triggeringEvent.equals(that.triggeringEvent) : that.triggeringEvent == null;
    }

    public int hashCode() {
        return this.triggeringEvent != null ? this.triggeringEvent.hashCode() : 0;
    }

    public Optional<EventContext> getTriggeringEvent() {
        return this.triggeringEvent;
    }

    public Optional<Map<String, String>> getEventMetadata() {
        return this.eventMetadata;
    }

    public Optional<Snapshot> getSnapshot() {
        return this.snapshot;
    }

    public UpdateOptions withTriggeringEvent(EventContext eventContext) {
        return new UpdateOptions(Optional.ofNullable(eventContext), this.eventMetadata, this.snapshot, this.interceptor);
    }

    public UpdateOptions withEventMetadata(Map<String, String> eventMetadata) {
        return new UpdateOptions(this.triggeringEvent, Optional.of(eventMetadata), this.snapshot, this.interceptor);
    }

    public UpdateOptions withSnapshot(Snapshot snapshot) {
        return new UpdateOptions(this.triggeringEvent, this.eventMetadata, Optional.of(snapshot), this.interceptor);
    }

    public UpdateOptions withInterceptor(AggregateRepositoryInterceptor interceptor) {
        return new UpdateOptions(this.triggeringEvent, this.eventMetadata, this.snapshot, Optional.of(interceptor));
    }

    public UpdateOptions withIdempotencyKey(String idempotencyKey) {
        return this;
    }

    public Optional<AggregateRepositoryInterceptor> getInterceptor() {
        return this.interceptor;
    }
}

