/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.event;

import com.networknt.eventuate.common.CompletableFutureUtil;
import com.networknt.eventuate.common.DispatchedEvent;
import com.networknt.eventuate.common.Event;
import com.networknt.eventuate.common.impl.EventuateActivity;
import com.networknt.eventuate.event.EventHandler;
import com.networknt.eventuate.eventhandling.exceptionhandling.EventDeliveryExceptionHandlerManager;
import com.networknt.eventuate.eventhandling.exceptionhandling.EventDeliveryExceptionHandlerWithState;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDispatcher {
    private static Logger logger = LoggerFactory.getLogger(EventDispatcher.class);
    private final String subscriberId;
    private final Map<Class<?>, EventHandler> eventTypesAndHandlers;
    private EventDeliveryExceptionHandlerManager eventDeliveryExceptionHandlerManager;

    public EventDispatcher(String subscriberId, Map<Class<?>, EventHandler> eventTypesAndHandlers, EventDeliveryExceptionHandlerManager eventDeliveryExceptionHandlerManager) {
        this.subscriberId = subscriberId;
        this.eventTypesAndHandlers = eventTypesAndHandlers;
        this.eventDeliveryExceptionHandlerManager = eventDeliveryExceptionHandlerManager;
    }

    public CompletableFuture<?> dispatch(DispatchedEvent<Event> de) {
        EventHandler eventHandler = this.eventTypesAndHandlers.get(de.getEventType());
        if (eventHandler != null) {
            CompletableFuture<Object> result = new CompletableFuture<Object>();
            this.dispatchEvent(de, eventHandler, result, Optional.empty());
            return result;
        }
        RuntimeException ex = new RuntimeException("No handler for event - subscriberId: " + this.subscriberId + ", " + de.getEventType());
        logger.error("dispatching failure", ex);
        CompletableFuture completableFuture = new CompletableFuture();
        completableFuture.completeExceptionally(ex);
        return completableFuture;
    }

    private void dispatchEvent(DispatchedEvent<Event> de, EventHandler eventHandler, CompletableFuture<Object> result, Optional<EventDeliveryExceptionHandlerWithState> ehr) {
        if (EventuateActivity.activityLogger.isDebugEnabled()) {
            EventuateActivity.activityLogger.debug("Invoking event handler {} {} {}", this.subscriberId, de, eventHandler);
        }
        CompletableFuture<?> r1 = eventHandler.dispatch(de);
        if (EventuateActivity.activityLogger.isDebugEnabled()) {
            EventuateActivity.activityLogger.debug("Invoking event handler {} {} {}", this.subscriberId, de, eventHandler);
            CompletableFutureUtil.tap(r1, (o, throwable) -> {
                if (throwable == null) {
                    EventuateActivity.activityLogger.debug("Invoked event handler {} {} {}", this.subscriberId, de, eventHandler);
                } else {
                    EventuateActivity.activityLogger.debug(String.format("Event handler failed %s %s %s", this.subscriberId, de, eventHandler), (Throwable)throwable);
                }
            });
        }
        r1.handle((o, t) -> {
            if (t == null) {
                result.complete(o);
            } else {
                Throwable t1 = CompletableFutureUtil.unwrap(this.unwrap(CompletableFutureUtil.unwrap(t)));
                EventDeliveryExceptionHandlerWithState eventDeliveryExceptionHandlerWithState = ehr.orElseGet(() -> this.eventDeliveryExceptionHandlerManager.getEventHandler(t1));
                eventDeliveryExceptionHandlerWithState.handle(t1, () -> this.dispatchEvent(de, eventHandler, result, Optional.of(eventDeliveryExceptionHandlerWithState)), result::completeExceptionally, () -> result.complete(null));
            }
            return null;
        });
    }

    private Throwable unwrap(Throwable t1) {
        return t1 instanceof InvocationTargetException ? t1.getCause() : t1;
    }
}

