/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.event;

import com.networknt.eventuate.common.AggregateRepository;
import com.networknt.eventuate.common.Command;
import com.networknt.eventuate.common.CommandProcessingAggregate;
import com.networknt.eventuate.common.DispatchedEvent;
import com.networknt.eventuate.common.EntityWithIdAndVersion;
import com.networknt.eventuate.common.Event;
import com.networknt.eventuate.common.EventContext;
import com.networknt.eventuate.common.EventHandlerContext;
import com.networknt.eventuate.common.EventuateAggregateStore;
import com.networknt.eventuate.common.Int128;
import com.networknt.eventuate.common.SaveOptions;
import com.networknt.eventuate.common.UpdateOptions;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

class EventHandlerContextImpl
implements EventHandlerContext<Event> {
    private EventuateAggregateStore aggregateStore;
    private final DispatchedEvent<Event> de;

    public EventHandlerContextImpl(EventuateAggregateStore aggregateStore, DispatchedEvent<Event> de) {
        this.aggregateStore = aggregateStore;
        this.de = de;
    }

    @Override
    public Event getEvent() {
        return this.de.getEvent();
    }

    @Override
    public Int128 getEventId() {
        return this.de.getEventId();
    }

    @Override
    public Class<Event> getEventType() {
        return this.de.getEventType();
    }

    @Override
    public String getEntityId() {
        return this.de.getEntityId();
    }

    @Override
    public Integer getSwimlane() {
        return this.de.getSwimlane();
    }

    @Override
    public Long getOffset() {
        return this.de.getOffset();
    }

    @Override
    public EventContext getEventContext() {
        return this.de.getEventContext();
    }

    @Override
    public Optional<Map<String, String>> getEventMetadata() {
        return this.de.getEventMetadata();
    }

    @Override
    public <U extends CommandProcessingAggregate<U, CT>, CT extends Command> CompletableFuture<EntityWithIdAndVersion<U>> save(Class<U> entityClass, CT command, Optional<String> entityId) {
        AggregateRepository<U, CT> ar = new AggregateRepository<U, CT>(entityClass, this.aggregateStore);
        return ar.save(command, Optional.of(new SaveOptions().withId(entityId).withEventContext(this.de.getEventContext())));
    }

    @Override
    public <U extends CommandProcessingAggregate<U, CT>, CT extends Command> CompletableFuture<EntityWithIdAndVersion<U>> update(Class<U> entityClass, String entityId, CT command) {
        AggregateRepository<U, CT> ar = new AggregateRepository<U, CT>(entityClass, this.aggregateStore);
        return ar.update(entityId, command, Optional.of(new UpdateOptions().withTriggeringEvent(this.de.getEventContext())));
    }

    @Override
    public <A extends CommandProcessingAggregate<A, CT>, CT extends Command> CompletableFuture<EntityWithIdAndVersion<A>> updateWithProvidedCommand(Class<A> entityClass, String entityId, Function<A, Optional<CT>> commandProvider) {
        AggregateRepository<A, CT> ar = new AggregateRepository<A, CT>(entityClass, this.aggregateStore);
        return ar.updateWithProvidedCommand(entityId, commandProvider, Optional.of(new UpdateOptions().withTriggeringEvent(this.de.getEventContext())));
    }
}

