/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.event;

import com.networknt.eventuate.common.DispatchedEvent;
import com.networknt.eventuate.common.Event;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwimlaneDispatcher {
    private static Logger logger = LoggerFactory.getLogger(SwimlaneDispatcher.class);
    private String subscriberId;
    private Integer swimlane;
    private Executor executor;
    private final LinkedBlockingQueue<QueuedEvent> queue = new LinkedBlockingQueue();
    private AtomicBoolean running = new AtomicBoolean(false);

    public SwimlaneDispatcher(String subscriberId, Integer swimlane, Executor executor) {
        this.subscriberId = subscriberId;
        this.swimlane = swimlane;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> dispatch(DispatchedEvent<Event> de, Function<DispatchedEvent<Event>, CompletableFuture<?>> target) {
        LinkedBlockingQueue<QueuedEvent> linkedBlockingQueue = this.queue;
        synchronized (linkedBlockingQueue) {
            QueuedEvent qe = new QueuedEvent(de, target);
            this.queue.add(qe);
            logger.trace("added event to queue: {} {} {}", this.subscriberId, this.swimlane, de);
            if (this.running.compareAndSet(false, true)) {
                logger.trace("Stopped - attempting to process newly queued event: {} {}", (Object)this.subscriberId, (Object)this.swimlane);
                this.processNextQueuedEvent();
            } else {
                logger.trace("Running - Not attempting to process newly queued event: {} {}", (Object)this.subscriberId, (Object)this.swimlane);
            }
            return qe.future;
        }
    }

    private void processNextQueuedEvent() {
        this.executor.execute(this::processQueuedEvent);
    }

    public void processQueuedEvent() {
        QueuedEvent qe = this.getNextEvent();
        if (qe == null) {
            logger.trace("No queued event for {} {}", (Object)this.subscriberId, (Object)this.swimlane);
        } else {
            logger.trace("Invoking handler for event for {} {} {}", this.subscriberId, this.swimlane, qe.event);
            ((CompletableFuture)qe.target.apply(qe.event)).handle((success, throwable) -> {
                if (throwable == null) {
                    logger.debug("Handler succeeded for event for {} {} {}", this.subscriberId, this.swimlane, qe.event);
                    boolean x = qe.future.complete(success);
                    logger.trace("Completed future success {}", (Object)x);
                    logger.trace("Maybe processing next queued event {} {}", (Object)this.subscriberId, (Object)this.swimlane);
                    this.processNextQueuedEvent();
                } else {
                    logger.error(String.format("handler for %s %s  %s failed: ", this.subscriberId, this.swimlane, qe.event), (Throwable)throwable);
                    boolean x = qe.future.completeExceptionally((Throwable)throwable);
                    logger.trace("Completed future failed{}", (Object)x);
                }
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueuedEvent getNextEvent() {
        QueuedEvent qe1 = this.queue.poll();
        if (qe1 != null) {
            return qe1;
        }
        LinkedBlockingQueue<QueuedEvent> linkedBlockingQueue = this.queue;
        synchronized (linkedBlockingQueue) {
            QueuedEvent qe = this.queue.poll();
            if (qe == null) {
                this.running.compareAndSet(true, false);
            }
            return qe;
        }
    }

    class QueuedEvent {
        DispatchedEvent<Event> event;
        private Function<DispatchedEvent<Event>, CompletableFuture<?>> target;
        CompletableFuture<Object> future = new CompletableFuture();

        public QueuedEvent(DispatchedEvent<Event> event, Function<DispatchedEvent<Event>, CompletableFuture<?>> target) {
            this.event = event;
            this.target = target;
        }
    }
}

