/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.eventhandling.exceptionhandling;

import com.networknt.eventuate.common.impl.EventuateActivity;
import com.networknt.eventuate.eventhandling.exceptionhandling.EventDeliveryExceptionHandler;
import com.networknt.eventuate.eventhandling.exceptionhandling.EventDeliveryExceptionHandlerState;
import com.networknt.eventuate.eventhandling.exceptionhandling.EventuateClientScheduler;
import com.networknt.eventuate.eventhandling.exceptionhandling.RetryEventDeliveryExceptionHandlerState;
import java.time.Duration;
import java.util.Arrays;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryEventDeliveryExceptionHandler
implements EventDeliveryExceptionHandler {
    private final Logger logger = LoggerFactory.getLogger(RetryEventDeliveryExceptionHandler.class);
    private int maxRetries;
    private Class<? extends Throwable>[] supportedThrowables;
    private Duration retryInterval;
    private EventuateClientScheduler eventuateClientScheduler;

    public RetryEventDeliveryExceptionHandler(EventuateClientScheduler eventuateClientScheduler) {
        this.eventuateClientScheduler = eventuateClientScheduler;
    }

    @Override
    public boolean handles(Throwable t) {
        return Arrays.stream(this.supportedThrowables).anyMatch(th -> th.isInstance(t));
    }

    @Override
    public EventDeliveryExceptionHandlerState makeState(Throwable t) {
        EventuateActivity.activityLogger.debug("Begin handling: {}", (Object)t.getClass().getName());
        return new RetryEventDeliveryExceptionHandlerState(t);
    }

    @Override
    public void handle(EventDeliveryExceptionHandlerState state, Throwable t, Runnable retry, Consumer<Throwable> fail, Runnable ignore) {
        RetryEventDeliveryExceptionHandlerState myState = (RetryEventDeliveryExceptionHandlerState)state;
        if (!this.handles(t) || myState.retries++ >= this.maxRetries) {
            fail.accept(t);
        } else {
            long ms = this.retryInterval.toMillis();
            EventuateActivity.activityLogger.debug("Sleeping for {} ms", (Object)ms);
            this.eventuateClientScheduler.setTimer(ms, () -> {
                EventuateActivity.activityLogger.debug("Retrying delivery");
                retry.run();
            });
        }
    }

    @SafeVarargs
    public final RetryEventDeliveryExceptionHandler withExceptions(Class<? extends Throwable> ... throwables) {
        this.supportedThrowables = throwables;
        return this;
    }

    public RetryEventDeliveryExceptionHandler withMaxRetries(int numberOfRetries) {
        this.maxRetries = numberOfRetries;
        return this;
    }

    public RetryEventDeliveryExceptionHandler withInfiniteRetries() {
        return this.withMaxRetries(Integer.MAX_VALUE);
    }

    public RetryEventDeliveryExceptionHandler withRetryInterval(Duration retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }
}

