/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.server.common;

import com.networknt.eventuate.server.common.EventTableChangesToAggregateTopicTranslator;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.state.ConnectionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventuateLeaderSelectorListener
implements LeaderSelectorListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private EventTableChangesToAggregateTopicTranslator eventTableChangesToAggregateTopicTranslator;

    public EventuateLeaderSelectorListener(EventTableChangesToAggregateTopicTranslator eventTableChangesToAggregateTopicTranslator) {
        this.eventTableChangesToAggregateTopicTranslator = eventTableChangesToAggregateTopicTranslator;
    }

    @Override
    public void takeLeadership(CuratorFramework client) throws Exception {
        this.takeLeadership();
    }

    private void takeLeadership() throws InterruptedException {
        this.logger.info("Taking leadership");
        try {
            this.eventTableChangesToAggregateTopicTranslator.startCapturingChanges();
        }
        catch (Throwable t) {
            this.logger.error("In takeLeadership", t);
            throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
        }
        finally {
            this.logger.debug("TakeLeadership returning");
        }
    }

    @Override
    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        this.logger.debug("StateChanged: {}", (Object)newState);
        switch (newState) {
            case SUSPENDED: {
                this.resignLeadership();
                break;
            }
            case RECONNECTED: {
                try {
                    this.takeLeadership();
                }
                catch (InterruptedException e) {
                    this.logger.error("While handling RECONNECTED", e);
                }
                break;
            }
            case LOST: {
                this.resignLeadership();
            }
        }
    }

    private void resignLeadership() {
        this.logger.info("Resigning leadership");
        try {
            this.eventTableChangesToAggregateTopicTranslator.stopCapturingChanges();
        }
        catch (InterruptedException e) {
            this.logger.error("While handling SUSPEND", e);
        }
    }
}

