/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.registry.support.command;

import com.networknt.registry.NotifyListener;
import com.networknt.registry.URL;
import com.networknt.registry.support.FailbackRegistry;
import com.networknt.registry.support.command.CommandServiceManager;
import com.networknt.registry.support.command.ServiceListener;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommandFailbackRegistry
extends FailbackRegistry {
    private static final Logger logger = LoggerFactory.getLogger(CommandFailbackRegistry.class);
    private ConcurrentHashMap<URL, CommandServiceManager> commandManagerMap = new ConcurrentHashMap();

    public CommandFailbackRegistry(URL url) {
        super(url);
        if (logger.isInfoEnabled()) {
            logger.info("CommandFailbackRegistry init. url: " + url.toSimpleString());
        }
    }

    @Override
    protected void doSubscribe(URL url, NotifyListener listener) {
        if (logger.isInfoEnabled()) {
            logger.info("CommandFailbackRegistry subscribe. url: " + url.toSimpleString());
        }
        URL urlCopy = url.createCopy();
        CommandServiceManager manager = this.getCommandServiceManager(urlCopy);
        manager.addNotifyListener(listener);
        this.subscribeService(urlCopy, manager);
        List<URL> urls = this.doDiscover(urlCopy);
        if (urls != null && urls.size() > 0) {
            this.notify(urlCopy, listener, urls);
        }
    }

    @Override
    protected void doUnsubscribe(URL url, NotifyListener listener) {
        if (logger.isInfoEnabled()) {
            logger.info("CommandFailbackRegistry unsubscribe. url: " + url.toSimpleString());
        }
        URL urlCopy = url.createCopy();
        CommandServiceManager manager = this.commandManagerMap.get(urlCopy);
        manager.removeNotifyListener(listener);
        this.unsubscribeService(urlCopy, manager);
    }

    @Override
    protected List<URL> doDiscover(URL url) {
        if (logger.isInfoEnabled()) {
            logger.info("CommandFailbackRegistry discover. url: " + url.toSimpleString());
        }
        List<URL> finalResult = this.discoverService(url.createCopy());
        if (logger.isInfoEnabled()) {
            logger.info("CommandFailbackRegistry discover size: " + finalResult.size() + ", result:" + finalResult.toString());
        }
        return finalResult;
    }

    private CommandServiceManager getCommandServiceManager(URL urlCopy) {
        CommandServiceManager manager = this.commandManagerMap.get(urlCopy);
        if (manager == null) {
            manager = new CommandServiceManager(urlCopy);
            manager.setRegistry(this);
            CommandServiceManager manager1 = this.commandManagerMap.putIfAbsent(urlCopy, manager);
            if (manager1 != null) {
                manager = manager1;
            }
        }
        return manager;
    }

    public ConcurrentHashMap<URL, CommandServiceManager> getCommandManagerMap() {
        return this.commandManagerMap;
    }

    protected abstract void subscribeService(URL var1, ServiceListener var2);

    protected abstract void unsubscribeService(URL var1, ServiceListener var2);

    protected abstract List<URL> discoverService(URL var1);
}

