/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import com.networknt.config.Config;
import com.networknt.security.JwtHelper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jose4j.jwt.JwtClaims;

public class JwtMockHandler
implements HttpHandler {
    public static final String ENABLE_MOCK_JWT = "enableMockJwt";

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        resMap.put("access_token", JwtHelper.getJwt(this.mockClaims()));
        resMap.put("token_type", "bearer");
        resMap.put("expires_in", 600);
        exchange.getResponseSender().send(ByteBuffer.wrap(Config.getInstance().getMapper().writeValueAsBytes(resMap)));
    }

    public JwtClaims mockClaims() {
        JwtClaims claims = JwtHelper.getDefaultJwtClaims();
        claims.setClaim("user_id", "steve");
        claims.setClaim("user_type", "EMPLOYEE");
        claims.setClaim("client_id", "aaaaaaaa-1234-1234-1234-bbbbbbbb");
        List<String> scope = Arrays.asList("api.r", "api.w");
        claims.setStringListClaim("scope", scope);
        return claims;
    }
}

