/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.server;

import com.networknt.client.Http2Client;
import com.networknt.common.DecryptUtil;
import com.networknt.config.Config;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.registry.Registry;
import com.networknt.registry.URL;
import com.networknt.registry.URLImpl;
import com.networknt.server.DummyTrustManager;
import com.networknt.server.HandlerProvider;
import com.networknt.server.ServerConfig;
import com.networknt.server.ShutdownHookProvider;
import com.networknt.server.StartupHookProvider;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.switcher.SwitcherUtil;
import com.networknt.utility.Util;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.server.HttpHandler;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;

public class Server {
    static final Logger logger = LoggerFactory.getLogger(Server.class);
    public static final String CONFIG_NAME = "server";
    public static final String CONFIG_SECRET = "secret";
    static final String DEFAULT_ENV = "test";
    static final String LIGHT_ENV = "light-env";
    static final String LIGHT_CONFIG_SERVER_URI = "light-config-server-uri";
    static final String STATUS_HOST_IP = "STATUS_HOST_IP";
    static final String SID = "sId";
    public static ServerConfig config = (ServerConfig)Config.getInstance().getJsonObjectConfig("server", ServerConfig.class);
    public static Map<String, Object> secret = DecryptUtil.decryptMap(Config.getInstance().getJsonMapConfig("secret"));
    public static final TrustManager[] TRUST_ALL_CERTS = new X509TrustManager[]{new DummyTrustManager()};
    protected static boolean shutdownRequested = false;
    static Undertow server = null;
    static URL serviceUrl;
    static Registry registry;
    static SSLContext sslContext;

    public static void main(String[] args) {
        logger.info("server starts");
        System.setProperty("org.jboss.logging.provider", "slf4j");
        MDC.put(SID, config.getServiceId());
        Server.loadConfig();
        Server.start();
    }

    public static void start() {
        int i;
        Server.addDaemonShutdownHook();
        StartupHookProvider[] startupHookProviders = SingletonServiceFactory.getBeans(StartupHookProvider.class);
        if (startupHookProviders != null) {
            Arrays.stream(startupHookProviders).forEach(s -> s.onStartup());
        }
        HttpHandler handler = null;
        HandlerProvider handlerProvider = SingletonServiceFactory.getBean(HandlerProvider.class);
        if (handlerProvider != null) {
            handler = handlerProvider.getHandler();
        }
        if (handler == null) {
            logger.error("Unable to start the server - no route handler provider available in service.yml");
            throw new RuntimeException("Unable to start the server - no route handler provider available in service.yml");
        }
        MiddlewareHandler[] middlewareHandlers = SingletonServiceFactory.getBeans(MiddlewareHandler.class);
        if (middlewareHandlers != null) {
            for (i = middlewareHandlers.length - 1; i >= 0; --i) {
                logger.info("Plugin: " + middlewareHandlers[i].getClass().getName());
                if (!middlewareHandlers[i].isEnabled()) continue;
                handler = middlewareHandlers[i].setNext(handler);
                middlewareHandlers[i].register();
            }
        }
        if (Server.config.dynamicPort) {
            boolean b;
            for (i = Server.config.minPort; i < Server.config.maxPort && !(b = Server.bind(handler, i)); ++i) {
            }
        } else {
            Server.bind(handler, -1);
        }
    }

    private static boolean bind(HttpHandler handler, int port) {
        try {
            Undertow.Builder builder = Undertow.builder();
            if (Server.config.enableHttps) {
                port = port < 0 ? Server.config.httpsPort : port;
                sslContext = Server.createSSLContext();
                builder.addHttpsListener(port, config.getIp(), sslContext);
            } else if (Server.config.enableHttp) {
                port = port < 0 ? Server.config.httpPort : port;
                builder.addHttpListener(port, config.getIp());
            } else {
                throw new RuntimeException("Unable to start the server as both http and https are disabled in server.yml");
            }
            if (Server.config.enableHttp2) {
                builder.setServerOption(UndertowOptions.ENABLE_HTTP2, true);
            }
            server = builder.setBufferSize(16384).setIoThreads(Runtime.getRuntime().availableProcessors() * 2).setSocketOption(Options.BACKLOG, 10000).setServerOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, false).setServerOption(UndertowOptions.ALWAYS_SET_DATE, true).setServerOption(UndertowOptions.RECORD_REQUEST_START_TIME, false).setHandler(Handlers.header(handler, "Server", "L")).setWorkerThreads(200).build();
            server.start();
            System.out.println("HOST IP " + System.getenv(STATUS_HOST_IP));
            if (Server.config.enableRegistry) {
                registry = SingletonServiceFactory.getBean(Registry.class);
                if (registry == null) {
                    throw new RuntimeException("Could not find registry instance in service map");
                }
                String ipAddress = System.getenv(STATUS_HOST_IP);
                if (ipAddress == null) {
                    InetAddress inetAddress = Util.getInetAddress();
                    ipAddress = inetAddress.getHostAddress();
                }
                HashMap<String, String> parameters = new HashMap<String, String>();
                if (config.getEnvironment() != null) {
                    parameters.put("environment", config.getEnvironment());
                }
                serviceUrl = new URLImpl("light", ipAddress, port, config.getServiceId(), parameters);
                registry.register(serviceUrl);
                if (logger.isInfoEnabled()) {
                    logger.info("register service: " + serviceUrl.toFullStr());
                }
                SwitcherUtil.setSwitcherValue("RegistryHeartBeat", true);
                if (logger.isInfoEnabled()) {
                    logger.info("Registry heart beat switcher is on");
                }
            }
            if (Server.config.enableHttp) {
                System.out.println("Http Server started on ip:" + config.getIp() + " Port:" + port);
                if (logger.isInfoEnabled()) {
                    logger.info("Http Server started on ip:" + config.getIp() + " Port:" + port);
                }
            } else {
                System.out.println("Http port disabled.");
                if (logger.isInfoEnabled()) {
                    logger.info("Http port disabled.");
                }
            }
            if (Server.config.enableHttps) {
                System.out.println("Https Server started on ip:" + config.getIp() + " Port:" + port);
                if (logger.isInfoEnabled()) {
                    logger.info("Https Server started on ip:" + config.getIp() + " Port:" + port);
                }
            } else {
                System.out.println("Https port disabled.");
                if (logger.isInfoEnabled()) {
                    logger.info("Https port disabled.");
                }
            }
            return true;
        }
        catch (Exception e) {
            System.out.println("Failed to bind to port " + port);
            if (logger.isInfoEnabled()) {
                logger.info("Failed to bind to port " + port);
            }
            return false;
        }
    }

    public static void stop() {
        if (server != null) {
            server.stop();
        }
    }

    public static void shutdown() {
        ShutdownHookProvider[] shutdownHookProviders;
        if (Server.config.enableRegistry && registry != null) {
            registry.unregister(serviceUrl);
            System.out.println("unregister serviceUrl " + serviceUrl);
            if (logger.isInfoEnabled()) {
                logger.info("unregister serviceUrl " + serviceUrl);
            }
        }
        if ((shutdownHookProviders = SingletonServiceFactory.getBeans(ShutdownHookProvider.class)) != null) {
            Arrays.stream(shutdownHookProviders).forEach(s -> s.onShutdown());
        }
        Server.stop();
        logger.info("Cleaning up before server shutdown");
    }

    protected static void addDaemonShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Server.shutdown();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyStore loadKeyStore() {
        String name = config.getKeystoreName();
        try (InputStream stream = Config.getInstance().getInputStreamFromFile(name);){
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(stream, ((String)secret.get("serverKeystorePass")).toCharArray());
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
        catch (Exception e) {
            logger.error("Unable to load keystore " + name, e);
            throw new RuntimeException("Unable to load keystore " + name, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static KeyStore loadTrustStore() {
        String name = config.getTruststoreName();
        try (InputStream stream = Config.getInstance().getInputStreamFromFile(name);){
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(stream, ((String)secret.get("serverTruststorePass")).toCharArray());
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
        catch (Exception e) {
            logger.error("Unable to load truststore " + name, e);
            throw new RuntimeException("Unable to load truststore " + name, e);
        }
    }

    private static TrustManager[] buildTrustManagers(KeyStore trustStore) {
        TrustManager[] trustManagers = null;
        if (trustStore == null) {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(trustStore);
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                logger.error("Unable to initialise TrustManager[]", e);
                throw new RuntimeException("Unable to initialise TrustManager[]", e);
            }
        } else {
            trustManagers = TRUST_ALL_CERTS;
        }
        return trustManagers;
    }

    private static KeyManager[] buildKeyManagers(KeyStore keyStore, char[] keyPass) {
        KeyManager[] keyManagers;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, keyPass);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            logger.error("Unable to initialise KeyManager[]", e);
            throw new RuntimeException("Unable to initialise KeyManager[]", e);
        }
        return keyManagers;
    }

    private static SSLContext createSSLContext() throws RuntimeException {
        try {
            KeyManager[] keyManagers = Server.buildKeyManagers(Server.loadKeyStore(), ((String)secret.get("serverKeyPass")).toCharArray());
            TrustManager[] trustManagers = config.isEnableTwoWayTls() ? Server.buildTrustManagers(Server.loadTrustStore()) : Server.buildTrustManagers(null);
            SSLContext sslContext = SSLContext.getInstance("TLSv1");
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (Exception e) {
            logger.error("Unable to create SSLContext", e);
            throw new RuntimeException("Unable to create SSLContext", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadConfig() {
        String configUri;
        String env = System.getProperty(LIGHT_ENV);
        if (env == null) {
            logger.warn("Warning! No light-env has been passed in from command line. Default to dev");
            env = DEFAULT_ENV;
        }
        if ((configUri = System.getProperty(LIGHT_CONFIG_SERVER_URI)) != null) {
            String targetMergeDirectory = System.getProperty("light-4j-config-dir");
            if (targetMergeDirectory == null) {
                logger.warn("Warning! No light-4j-config-dir has been passed in from command line.");
                return;
            }
            String version = Util.getJarVersion();
            String service = config.getServiceId();
            String tempDir = System.getProperty("java.io.tmpdir");
            String zipFile = tempDir + "/config.zip";
            String path = "/v1/config/" + version + "/" + env + "/" + service;
            Http2Client client = Http2Client.getInstance();
            ClientConnection connection = null;
            try {
                connection = client.connect(new URI(configUri), Http2Client.WORKER, Http2Client.SSL, Http2Client.POOL, OptionMap.create(UndertowOptions.ENABLE_HTTP2, true)).get();
            }
            catch (Exception e) {
                logger.error("Exeption:", e);
            }
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
            try {
                ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(path);
                request.getRequestHeaders().put(Headers.HOST, "localhost");
                connection.sendRequest(request, client.createClientCallback(reference, latch));
                latch.await();
                int statusCode = reference.get().getResponseCode();
                if (statusCode >= 300) {
                    logger.error("Failed to load config from config server" + statusCode + ":" + reference.get().getAttachment(Http2Client.RESPONSE_BODY));
                    throw new Exception("Failed to load config from config server: " + statusCode);
                }
                FileOutputStream fos = new FileOutputStream(zipFile);
                fos.write(reference.get().getAttachment(Http2Client.RESPONSE_BODY).getBytes());
                fos.close();
                Server.unzipFile(zipFile, targetMergeDirectory);
            }
            catch (Exception e) {
                logger.error("Exception:", e);
            }
            finally {
                IoUtils.safeClose((Closeable)connection);
            }
        } else {
            logger.info("light-config-server-uri is missing in the command line. Use local config files");
        }
    }

    private static void mergeConfigFiles(String source, String target) {
    }

    private static void unzipFile(String path, String target) {
        try (ZipFile file = new ZipFile(path);){
            FileSystem fileSystem = FileSystems.getDefault();
            Enumeration<? extends ZipEntry> entries = file.entries();
            Files.createDirectory(fileSystem.getPath(target, new String[0]), new FileAttribute[0]);
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    System.out.println("Creating Directory:" + target + entry.getName());
                    Files.createDirectories(fileSystem.getPath(target + entry.getName(), new String[0]), new FileAttribute[0]);
                    continue;
                }
                InputStream is = file.getInputStream(entry);
                BufferedInputStream bis = new BufferedInputStream(is);
                String uncompressedFileName = target + entry.getName();
                Path uncompressedFilePath = fileSystem.getPath(uncompressedFileName, new String[0]);
                Files.createFile(uncompressedFilePath, new FileAttribute[0]);
                FileOutputStream fileOutput = new FileOutputStream(uncompressedFileName);
                while (bis.available() > 0) {
                    fileOutput.write(bis.read());
                }
                fileOutput.close();
                System.out.println("Written :" + entry.getName());
            }
        }
        catch (IOException e) {
            logger.error("IOException", e);
        }
    }
}

