/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.status;

import com.networknt.config.Config;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.status.StatusSerializer;
import com.networknt.utility.ModuleRegistry;
import java.util.Map;

public class Status {
    public static final String CONFIG_NAME = "status";
    public static final Map<String, Object> config = Config.getInstance().getJsonMapConfigNoCache("status");
    private static StatusSerializer statusSerializer;
    private int statusCode;
    private String code;
    private String message;
    private String description;

    public Status() {
    }

    public Status(String code, Object ... args) {
        this.code = code;
        Map map = (Map)config.get(code);
        if (map != null) {
            this.statusCode = (Integer)map.get("statusCode");
            this.message = (String)map.get("message");
            this.description = String.format((String)map.get("description"), args);
        }
    }

    public Status(int statusCode, String code, String message, String description) {
        this.statusCode = statusCode;
        this.code = code;
        this.message = message;
        this.description = description;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        if (statusSerializer != null) {
            return statusSerializer.serializeStatus(this);
        }
        return "{\"statusCode\":" + this.getStatusCode() + ",\"code\":\"" + this.getCode() + "\",\"message\":\"" + this.getMessage() + "\",\"description\":\"" + this.getDescription() + "\"}";
    }

    static {
        ModuleRegistry.registerModule(Status.class.getName(), config, null);
        try {
            statusSerializer = SingletonServiceFactory.getBean(StatusSerializer.class);
        }
        catch (ExceptionInInitializerError e) {
            statusSerializer = null;
        }
    }
}

