/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.tram.cdc.mysql.connector;

import com.github.shyiko.mysql.binlog.event.WriteRowsEventData;
import com.networknt.eventuate.cdc.mysql.binlog.IWriteRowsEventDataParser;
import com.networknt.eventuate.common.impl.JSonMapper;
import com.networknt.eventuate.jdbc.EventuateSchema;
import com.networknt.eventuate.server.common.BinlogFileOffset;
import com.networknt.tram.cdc.mysql.connector.MessageWithDestination;
import com.networknt.tram.message.common.MessageImpl;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteRowsEventDataParser
implements IWriteRowsEventDataParser<MessageWithDestination> {
    private DataSource dataSource;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ID = "id";
    private static final String DESTINATION = "destination";
    private static final String HEADERS = "headers";
    private static final String PAYLOAD = "payload";
    private Map<String, Integer> columnOrders = new HashMap<String, Integer>();
    private EventuateSchema eventuateSchema;

    public WriteRowsEventDataParser(DataSource dataSource, EventuateSchema eventuateSchema) {
        this.dataSource = dataSource;
        this.eventuateSchema = eventuateSchema;
    }

    @Override
    public MessageWithDestination parseEventData(WriteRowsEventData eventData, String binlogFilename, long position) throws IOException {
        if (this.columnOrders.isEmpty()) {
            try {
                this.getColumnOrders();
            }
            catch (SQLException e) {
                this.logger.error("Error getting metadata", e);
                throw new RuntimeException(e);
            }
        }
        String id = (String)((Object)this.getValue(eventData, ID));
        String destination = (String)((Object)this.getValue(eventData, DESTINATION));
        String payload = (String)((Object)this.getValue(eventData, PAYLOAD));
        Map headers = JSonMapper.fromJson((String)((Object)this.getValue(eventData, HEADERS)), Map.class);
        headers.put("ID", id);
        headers.put("binlogfile", binlogFilename);
        headers.put("binlogposition", Long.toString(position));
        return new MessageWithDestination(destination, new MessageImpl(payload, headers), new BinlogFileOffset(binlogFilename, position));
    }

    private Serializable getValue(WriteRowsEventData eventData, String columnName) {
        if (this.columnOrders.containsKey(columnName)) {
            return eventData.getRows().get(0)[this.columnOrders.get(columnName) - 1];
        }
        throw new RuntimeException("Column with name [" + columnName + "] not found. Have " + this.columnOrders.keySet());
    }

    private void getColumnOrders() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet columnResultSet = metaData.getColumns(this.eventuateSchema.isEmpty() ? null : this.eventuateSchema.getEventuateDatabaseSchema(), "public", "MESSAGE".toLowerCase(), null);){
                while (columnResultSet.next()) {
                    this.columnOrders.put(columnResultSet.getString("COLUMN_NAME").toLowerCase(), columnResultSet.getInt("ORDINAL_POSITION"));
                }
            }
        }
    }
}

