/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.tram.message.common;

import com.networknt.tram.message.common.Message;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.builder.ToStringBuilder;

public class MessageImpl
implements Message {
    private String payload;
    private Map<String, String> headers;

    public MessageImpl() {
    }

    public MessageImpl(String payload, Map<String, String> headers) {
        this.payload = payload;
        this.headers = headers;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public Optional<String> getHeader(String name) {
        return Optional.ofNullable(this.headers.get(name));
    }

    @Override
    public String getRequiredHeader(String name) {
        String s = this.headers.get(name);
        if (s == null) {
            throw new RuntimeException("No such header: " + name + " in this message " + this);
        }
        return s;
    }

    @Override
    public boolean hasHeader(String name) {
        return this.headers.containsKey(name);
    }

    @Override
    public String getId() {
        return this.getRequiredHeader("ID");
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }
}

