/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.utility;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeVerifierUtil {
    static final Logger logger = LoggerFactory.getLogger(CodeVerifierUtil.class);
    public static final String CODE_CHALLENGE_METHOD_S256 = "S256";
    public static final String CODE_CHALLENGE_METHOD_PLAIN = "plain";
    public static final int MIN_CODE_VERIFIER_LENGTH = 43;
    public static final int MAX_CODE_VERIFIER_LENGTH = 128;
    public static final int DEFAULT_CODE_VERIFIER_ENTROPY = 64;
    public static final int MIN_CODE_VERIFIER_ENTROPY = 32;
    public static final int MAX_CODE_VERIFIER_ENTROPY = 96;
    public static final Pattern VALID_CODE_CHALLENGE_PATTERN = Pattern.compile("^[0-9a-zA-Z\\-\\.~_]+$");

    public static String generateRandomCodeVerifier() {
        return CodeVerifierUtil.generateRandomCodeVerifier(new SecureRandom(), 64);
    }

    public static String generateRandomCodeVerifier(SecureRandom entropySource, int entropyBytes) {
        byte[] randomBytes = new byte[entropyBytes];
        entropySource.nextBytes(randomBytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(randomBytes);
    }

    public static String deriveCodeVerifierChallenge(String codeVerifier) {
        try {
            MessageDigest sha256Digester = MessageDigest.getInstance("SHA-256");
            sha256Digester.update(codeVerifier.getBytes("ISO_8859_1"));
            byte[] digestBytes = sha256Digester.digest();
            return Base64.getUrlEncoder().withoutPadding().encodeToString(digestBytes);
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("SHA-256 is not supported on this device! Using plain challenge", e);
            return codeVerifier;
        }
        catch (UnsupportedEncodingException e) {
            logger.error("ISO-8859-1 encoding not supported on this device!", e);
            throw new IllegalStateException("ISO-8859-1 encoding not supported", e);
        }
    }

    public static String getCodeVerifierChallengeMethod() {
        try {
            MessageDigest.getInstance("SHA-256");
            return CODE_CHALLENGE_METHOD_S256;
        }
        catch (NoSuchAlgorithmException e) {
            return CODE_CHALLENGE_METHOD_PLAIN;
        }
    }
}

