/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class LogContext {
    private final String logPrefix;

    public LogContext(String logPrefix) {
        this.logPrefix = logPrefix == null ? "" : logPrefix;
    }

    public LogContext() {
        this("");
    }

    public Logger logger(Class<?> clazz) {
        return new KafkaLogger(clazz, this.logPrefix);
    }

    public String logPrefix() {
        return this.logPrefix;
    }

    private static class KafkaLogger
    implements Logger {
        private final Logger logger;
        private final String logPrefix;

        public KafkaLogger(Class<?> clazz, String logPrefix) {
            this.logger = LoggerFactory.getLogger(clazz);
            this.logPrefix = logPrefix;
        }

        @Override
        public String getName() {
            return this.logger.getName();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        @Override
        public boolean isTraceEnabled(Marker marker) {
            return this.logger.isTraceEnabled(marker);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public boolean isDebugEnabled(Marker marker) {
            return this.logger.isDebugEnabled(marker);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public boolean isInfoEnabled(Marker marker) {
            return this.logger.isInfoEnabled(marker);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public boolean isWarnEnabled(Marker marker) {
            return this.logger.isWarnEnabled(marker);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        @Override
        public boolean isErrorEnabled(Marker marker) {
            return this.logger.isErrorEnabled(marker);
        }

        @Override
        public void trace(String message) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(this.logPrefix + message);
            }
        }

        @Override
        public void trace(String message, Object arg) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(this.logPrefix + message, arg);
            }
        }

        @Override
        public void trace(String message, Object arg1, Object arg2) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(this.logPrefix + message, arg1, arg2);
            }
        }

        @Override
        public void trace(String message, Object ... args) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(this.logPrefix + message, args);
            }
        }

        @Override
        public void trace(String msg, Throwable t) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(this.logPrefix + msg, t);
            }
        }

        @Override
        public void trace(Marker marker, String msg) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(marker, this.logPrefix + msg);
            }
        }

        @Override
        public void trace(Marker marker, String format, Object arg) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(marker, this.logPrefix + format, arg);
            }
        }

        @Override
        public void trace(Marker marker, String format, Object arg1, Object arg2) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(marker, this.logPrefix + format, arg1, arg2);
            }
        }

        @Override
        public void trace(Marker marker, String format, Object ... argArray) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(marker, this.logPrefix + format, argArray);
            }
        }

        @Override
        public void trace(Marker marker, String msg, Throwable t) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(marker, this.logPrefix + msg, t);
            }
        }

        @Override
        public void debug(String message) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.logPrefix + message);
            }
        }

        @Override
        public void debug(String message, Object arg) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.logPrefix + message, arg);
            }
        }

        @Override
        public void debug(String message, Object arg1, Object arg2) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.logPrefix + message, arg1, arg2);
            }
        }

        @Override
        public void debug(String message, Object ... args) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.logPrefix + message, args);
            }
        }

        @Override
        public void debug(String msg, Throwable t) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.logPrefix + msg, t);
            }
        }

        @Override
        public void debug(Marker marker, String msg) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(marker, this.logPrefix + msg);
            }
        }

        @Override
        public void debug(Marker marker, String format, Object arg) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(marker, this.logPrefix + format, arg);
            }
        }

        @Override
        public void debug(Marker marker, String format, Object arg1, Object arg2) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(marker, this.logPrefix + format, arg1, arg2);
            }
        }

        @Override
        public void debug(Marker marker, String format, Object ... arguments) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(marker, this.logPrefix + format, arguments);
            }
        }

        @Override
        public void debug(Marker marker, String msg, Throwable t) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(marker, this.logPrefix + msg, t);
            }
        }

        @Override
        public void warn(String message) {
            this.logger.warn(this.logPrefix + message);
        }

        @Override
        public void warn(String message, Object arg) {
            this.logger.warn(this.logPrefix + message, arg);
        }

        @Override
        public void warn(String message, Object arg1, Object arg2) {
            this.logger.warn(this.logPrefix + message, arg1, arg2);
        }

        @Override
        public void warn(String message, Object ... args) {
            this.logger.warn(this.logPrefix + message, args);
        }

        @Override
        public void warn(String msg, Throwable t) {
            this.logger.warn(this.logPrefix + msg, t);
        }

        @Override
        public void warn(Marker marker, String msg) {
            this.logger.warn(marker, this.logPrefix + msg);
        }

        @Override
        public void warn(Marker marker, String format, Object arg) {
            this.logger.warn(marker, this.logPrefix + format, arg);
        }

        @Override
        public void warn(Marker marker, String format, Object arg1, Object arg2) {
            this.logger.warn(marker, this.logPrefix + format, arg1, arg2);
        }

        @Override
        public void warn(Marker marker, String format, Object ... arguments) {
            this.logger.warn(marker, this.logPrefix + format, arguments);
        }

        @Override
        public void warn(Marker marker, String msg, Throwable t) {
            this.logger.warn(marker, this.logPrefix + msg, t);
        }

        @Override
        public void error(String message) {
            this.logger.error(this.logPrefix + message);
        }

        @Override
        public void error(String message, Object arg) {
            this.logger.error(this.logPrefix + message, arg);
        }

        @Override
        public void error(String message, Object arg1, Object arg2) {
            this.logger.error(this.logPrefix + message, arg1, arg2);
        }

        @Override
        public void error(String message, Object ... args) {
            this.logger.error(this.logPrefix + message, args);
        }

        @Override
        public void error(String msg, Throwable t) {
            this.logger.error(this.logPrefix + msg, t);
        }

        @Override
        public void error(Marker marker, String msg) {
            this.logger.error(marker, this.logPrefix + msg);
        }

        @Override
        public void error(Marker marker, String format, Object arg) {
            this.logger.error(marker, this.logPrefix + format, arg);
        }

        @Override
        public void error(Marker marker, String format, Object arg1, Object arg2) {
            this.logger.error(marker, this.logPrefix + format, arg1, arg2);
        }

        @Override
        public void error(Marker marker, String format, Object ... arguments) {
            this.logger.error(marker, this.logPrefix + format, arguments);
        }

        @Override
        public void error(Marker marker, String msg, Throwable t) {
            this.logger.error(marker, this.logPrefix + msg, t);
        }

        @Override
        public void info(String message) {
            this.logger.info(this.logPrefix + message);
        }

        @Override
        public void info(String message, Object arg) {
            this.logger.info(this.logPrefix + message, arg);
        }

        @Override
        public void info(String message, Object arg1, Object arg2) {
            this.logger.info(this.logPrefix + message, arg1, arg2);
        }

        @Override
        public void info(String message, Object ... args) {
            this.logger.info(this.logPrefix + message, args);
        }

        @Override
        public void info(String msg, Throwable t) {
            this.logger.info(this.logPrefix + msg, t);
        }

        @Override
        public void info(Marker marker, String msg) {
            this.logger.info(marker, this.logPrefix + msg);
        }

        @Override
        public void info(Marker marker, String format, Object arg) {
            this.logger.info(marker, this.logPrefix + format, arg);
        }

        @Override
        public void info(Marker marker, String format, Object arg1, Object arg2) {
            this.logger.info(marker, this.logPrefix + format, arg1, arg2);
        }

        @Override
        public void info(Marker marker, String format, Object ... arguments) {
            this.logger.info(marker, this.logPrefix + format, arguments);
        }

        @Override
        public void info(Marker marker, String msg, Throwable t) {
            this.logger.info(marker, this.logPrefix + msg, t);
        }
    }
}

