/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.tram.event.subscriber;

import com.networknt.tram.event.subscriber.DomainEventHandler;
import com.networknt.tram.message.common.Message;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DomainEventHandlers {
    private List<DomainEventHandler> handlers;

    public DomainEventHandlers(List<DomainEventHandler> handlers) {
        this.handlers = handlers;
    }

    public Set<String> getAggregateTypesAndEvents() {
        return this.handlers.stream().map(DomainEventHandler::getAggregateType).collect(Collectors.toSet());
    }

    public Optional<DomainEventHandler> findTargetMethod(Message message) {
        return this.handlers.stream().filter(h -> h.handles(message)).findFirst();
    }
}

