/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.tram.event.subscriber;

import com.networknt.tram.event.common.DomainEvent;
import com.networknt.tram.event.subscriber.DomainEventEnvelope;
import com.networknt.tram.event.subscriber.DomainEventHandler;
import com.networknt.tram.event.subscriber.DomainEventHandlers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class DomainEventHandlersBuilder {
    private String aggregateType;
    private List<DomainEventHandler> handlers = new ArrayList<DomainEventHandler>();

    public DomainEventHandlersBuilder(String aggregateType) {
        this.aggregateType = aggregateType;
    }

    public static DomainEventHandlersBuilder forAggregateType(String aggregateType) {
        return new DomainEventHandlersBuilder(aggregateType);
    }

    public <E extends DomainEvent> DomainEventHandlersBuilder onEvent(Class<E> eventClass, Consumer<DomainEventEnvelope<E>> handler) {
        this.handlers.add(new DomainEventHandler(this.aggregateType, eventClass, e -> handler.accept((DomainEventEnvelope)e)));
        return this;
    }

    public DomainEventHandlers build() {
        return new DomainEventHandlers(this.handlers);
    }
}

