/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.tram.event.subscriber;

import com.networknt.config.JsonMapper;
import com.networknt.tram.event.common.DomainEvent;
import com.networknt.tram.event.subscriber.DomainEventEnvelopeImpl;
import com.networknt.tram.event.subscriber.DomainEventHandler;
import com.networknt.tram.event.subscriber.DomainEventHandlers;
import com.networknt.tram.message.common.Message;
import com.networknt.tram.message.consumer.MessageConsumer;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainEventDispatcher {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String eventDispatcherId;
    private DomainEventHandlers domainEventHandlers;
    private MessageConsumer messageConsumer;

    public DomainEventDispatcher(String eventDispatcherId, DomainEventHandlers domainEventHandlers, MessageConsumer messageConsumer) {
        this.eventDispatcherId = eventDispatcherId;
        this.domainEventHandlers = domainEventHandlers;
        this.messageConsumer = messageConsumer;
    }

    public void initialize() {
        this.messageConsumer.subscribe(this.eventDispatcherId, this.domainEventHandlers.getAggregateTypesAndEvents(), this::messageHandler);
    }

    public void messageHandler(Message message) {
        String aggregateType = message.getRequiredHeader("event-aggregate-type");
        Optional<DomainEventHandler> handler = this.domainEventHandlers.findTargetMethod(message);
        if (!handler.isPresent()) {
            return;
        }
        DomainEvent param = (DomainEvent)JsonMapper.fromJson((String)message.getPayload(), handler.get().getEventClass());
        handler.get().invoke(new DomainEventEnvelopeImpl<DomainEvent>(message, aggregateType, message.getRequiredHeader("event-aggregate-id"), message.getRequiredHeader("ID"), param));
    }

    public void finish() {
        this.messageConsumer.close();
    }
}

