/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.tram.event.subscriber;

import com.networknt.tram.event.common.DomainEvent;
import com.networknt.tram.event.subscriber.DomainEventEnvelope;
import com.networknt.tram.message.common.Message;
import java.util.function.Consumer;

public class DomainEventHandler {
    private String aggregateType;
    private final Class<DomainEvent> eventClass;
    private final Consumer<DomainEventEnvelope<DomainEvent>> handler;

    public DomainEventHandler(String aggregateType, Class<DomainEvent> eventClass, Consumer<DomainEventEnvelope<DomainEvent>> handler) {
        this.aggregateType = aggregateType;
        this.eventClass = eventClass;
        this.handler = handler;
    }

    public boolean handles(Message message) {
        return this.aggregateType.equals(message.getRequiredHeader("event-aggregate-type")) && this.eventClass.getName().equals(message.getRequiredHeader("event-type"));
    }

    public void invoke(DomainEventEnvelope<DomainEvent> dee) {
        this.handler.accept(dee);
    }

    public Class<DomainEvent> getEventClass() {
        return this.eventClass;
    }

    public String getAggregateType() {
        return this.aggregateType;
    }
}

