/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.tram.message.common;

import com.networknt.tram.message.common.IdGenerator;
import com.networknt.tram.message.common.Int128;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdGeneratorImpl
implements IdGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long MAX_COUNTER = 65536L;
    private Long macAddress;
    private long currentPeriod = this.timeNow();
    private long counter = 0L;

    public IdGeneratorImpl() {
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                if (iface.getHardwareAddress() == null) continue;
                this.macAddress = this.toLong(iface.getHardwareAddress());
                this.logger.debug("Mac address {}", (Object)this.macAddress);
                break;
            }
            if (this.macAddress == null) {
                throw new RuntimeException("Cannot find mac address");
            }
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    private Long toLong(byte[] bytes) {
        long result = 0L;
        for (byte b : bytes) {
            result = (result << 8) + (long)(b & 0xFF);
        }
        return result;
    }

    private long timeNow() {
        return System.currentTimeMillis();
    }

    private Int128 makeId() {
        return new Int128(this.currentPeriod, (this.macAddress << 16) + this.counter);
    }

    public Int128 genIdInternal() {
        long now = this.timeNow();
        if (this.currentPeriod != now || this.counter == 65536L) {
            long oldPeriod = this.currentPeriod;
            while ((this.currentPeriod = this.timeNow()) <= oldPeriod) {
            }
            this.counter = 0L;
        }
        Int128 id = this.makeId();
        ++this.counter;
        return id;
    }

    @Override
    public synchronized Int128 genId() {
        return this.genIdInternal();
    }
}

