/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.tram.message.common;

import com.networknt.config.JsonMapper;
import com.networknt.tram.message.common.Message;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class MessageImpl
implements Message {
    private String payload;
    private Map<String, String> headers;

    public MessageImpl() {
    }

    public MessageImpl(String payload, Map<String, String> headers) {
        this.payload = payload;
        this.headers = headers;
    }

    public String toString() {
        return JsonMapper.toJson((Object)this);
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public Optional<String> getHeader(String name) {
        return Optional.ofNullable(this.headers.get(name));
    }

    @Override
    public String getRequiredHeader(String name) {
        String s = this.headers.get(name);
        if (s == null) {
            throw new RuntimeException("No such header: " + name + " in this message " + this);
        }
        return s;
    }

    @Override
    public boolean hasHeader(String name) {
        return this.headers.containsKey(name);
    }

    @Override
    public String getId() {
        return this.getRequiredHeader("ID");
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void setPayload(String payload) {
        this.payload = payload;
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Override
    public void setHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    @Override
    public void removeHeader(String key) {
        this.headers.remove(key);
    }
}

