/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.tram.message.producer;

import com.networknt.tram.message.common.Message;
import com.networknt.tram.message.common.MessageInterceptor;
import com.networknt.tram.message.producer.MessageProducer;
import java.util.Arrays;

public abstract class AbstractMessageProducer
implements MessageProducer {
    protected MessageInterceptor[] messageInterceptors;

    protected AbstractMessageProducer(MessageInterceptor[] messageInterceptors) {
        this.messageInterceptors = messageInterceptors;
    }

    protected void preSend(Message message) {
        Arrays.stream(this.messageInterceptors).forEach(mi -> mi.preSend(message));
    }

    protected void postSend(Message message, RuntimeException e) {
        Arrays.stream(this.messageInterceptors).forEach(mi -> mi.postSend(message, e));
    }

    protected void sendMessage(String destination, Message message) {
        message.getHeaders().put("DESTINATION", destination);
        this.preSend(message);
        try {
            this.reallySendMessage(message);
            this.postSend(message, null);
        }
        catch (RuntimeException e) {
            this.postSend(message, e);
            throw e;
        }
    }

    protected abstract void reallySendMessage(Message var1);
}

