/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.tram.message.producer;

import com.networknt.tram.message.common.Message;
import com.networknt.tram.message.common.MessageImpl;
import java.util.HashMap;
import java.util.Map;

public class MessageBuilder {
    protected String body;
    protected Map<String, String> headers = new HashMap<String, String>();

    protected MessageBuilder() {
    }

    public MessageBuilder(String body) {
        this.body = body;
    }

    public MessageBuilder(Message message) {
        this(message.getPayload());
        this.headers = message.getHeaders();
    }

    public static MessageBuilder withPayload(String payload) {
        return new MessageBuilder(payload);
    }

    public MessageBuilder withHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public MessageBuilder withExtraHeaders(String prefix, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.headers.put(prefix + entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Message build() {
        return new MessageImpl(this.body, this.headers);
    }

    public static MessageBuilder withMessage(Message message) {
        return new MessageBuilder(message);
    }
}

