/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.tram.producer;

import com.networknt.config.JsonMapper;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.tram.message.common.IdGenerator;
import com.networknt.tram.message.common.Message;
import com.networknt.tram.message.producer.MessageProducer;
import java.util.Objects;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageProducerKafkaImpl
implements MessageProducer {
    private static final Logger logger = LoggerFactory.getLogger(MessageProducerKafkaImpl.class);
    private IdGenerator idGenerator = (IdGenerator)SingletonServiceFactory.getBean(IdGenerator.class);

    public void send(String destination, Message message) {
        Objects.requireNonNull(destination);
        Objects.requireNonNull(message);
        String id = this.idGenerator.genId().asString();
        message.getHeaders().put("ID", id);
        try (KafkaProducer kafkaProducer = (KafkaProducer)SingletonServiceFactory.getBean(KafkaProducer.class);){
            kafkaProducer.initTransactions();
            kafkaProducer.beginTransaction();
            kafkaProducer.send(new ProducerRecord(destination, (Object)id, (Object)JsonMapper.toJson((Object)message)));
            kafkaProducer.commitTransaction();
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

