/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.tram.test;

import com.networknt.service.SingletonServiceFactory;
import com.networknt.tram.message.consumer.MessageConsumer;
import com.networknt.tram.message.consumer.MessageHandler;
import com.networknt.tram.message.producer.MessageBuilder;
import com.networknt.tram.message.producer.MessageProducer;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TramIntegrationIT {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private MessageProducer messageProducer = (MessageProducer)SingletonServiceFactory.getBean(MessageProducer.class);
    private MessageConsumer messageConsumer = (MessageConsumer)SingletonServiceFactory.getBean(MessageConsumer.class);

    public void shouldDoSomething() throws InterruptedException {
        String destination = "Destination-" + System.currentTimeMillis();
        String subscriberId = "SubscriberId-" + System.currentTimeMillis();
        CountDownLatch latch = new CountDownLatch(1);
        MessageHandler handler = message -> {
            System.out.println("Got message=" + message);
            latch.countDown();
        };
        this.messageConsumer.subscribe(subscriberId, Collections.singleton(destination), handler);
        this.messageProducer.send(destination, MessageBuilder.withPayload((String)"Hello").build());
        Assert.assertTrue((String)"Expected message", (boolean)latch.await(10L, TimeUnit.SECONDS));
    }
}

