/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.json.pretty;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;

public class PrettyJson {
    private static JSONParser parser = new JSONParser();
    private static final ContainerFactory containerFactory = new ContainerFactory(){

        @Override
        public List<Object> createArrayContainer() {
            return new LinkedList<Object>();
        }

        @Override
        public Map<String, Object> createObjectContainer() {
            return new LinkedHashMap<String, Object>();
        }
    };
    private Style style;

    public PrettyJson(Style style) {
        if (style == null) {
            throw new IllegalArgumentException("The style must not be null");
        }
        this.style = style;
    }

    public PrettyJson() {
        this(Style.DEFAULT);
    }

    public void setStyle(Style style) {
        if (style == null) {
            throw new IllegalArgumentException("The style must not be null");
        }
        this.style = style;
    }

    public Style getStyle() {
        return this.style;
    }

    public static String repeat(char c, int times) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < times; ++i) {
            b.append(c);
        }
        return b.toString();
    }

    public String format(boolean b) {
        if (b) {
            return "true";
        }
        return "false";
    }

    public String format(Number n) {
        return n.toString();
    }

    public String format(String s) {
        return "\"" + JSONObject.escape(s) + "\"";
    }

    public String formatNull() {
        return "null";
    }

    public String format(List<Object> a, int indent) {
        String s = "[ ";
        if (a.isEmpty()) {
            return s + "]";
        }
        boolean hasComplexItems = false;
        for (Object item : a) {
            if (item == null || item instanceof Boolean || item instanceof Number || item instanceof String) continue;
            hasComplexItems = true;
            break;
        }
        boolean breakItems = hasComplexItems || a.size() > 3;
        Iterator<Object> it = a.iterator();
        int subIndent = indent + 2;
        boolean first = true;
        while (it.hasNext()) {
            Object item = it.next();
            if (first) {
                first = false;
                if (this.style == Style.DEFAULT && breakItems) {
                    s = s + "\n" + PrettyJson.repeat(' ', indent + 2);
                } else if (this.style != Style.COMPACT && !breakItems) {
                    // empty if block
                }
            } else if (breakItems) {
                s = s + PrettyJson.repeat(' ', indent + 2);
            }
            if (item instanceof Boolean) {
                s = s + this.format((Boolean)item);
            } else if (item instanceof Number) {
                s = s + this.format((Number)item);
            } else if (item instanceof String) {
                s = s + this.format((String)item);
            } else if (item instanceof List) {
                s = s + this.format((List)item, subIndent);
            } else if (item instanceof Map) {
                s = s + this.format((Map)item, subIndent);
            } else if (item == null) {
                s = s + this.formatNull();
            }
            if (!it.hasNext()) continue;
            s = s + ", ";
            if (!breakItems) continue;
            s = s + "\n";
        }
        if (this.style == Style.DEFAULT) {
            if (breakItems) {
                return s + "\n" + PrettyJson.repeat(' ', indent) + "]";
            }
            return s + " ]";
        }
        return s + " ]";
    }

    public String format(List<Object> a) {
        return this.format(a, 0);
    }

    public String format(Map<String, Object> o, int indent) {
        String s = "{ ";
        if (o.isEmpty()) {
            return s + "}";
        }
        int maxKeyLen = 0;
        for (String key : o.keySet()) {
            if (key.length() <= maxKeyLen) continue;
            maxKeyLen = key.length();
        }
        Iterator<Map.Entry<String, Object>> it = o.entrySet().iterator();
        int subIndent = indent + maxKeyLen + 7;
        boolean first = true;
        while (it.hasNext()) {
            Map.Entry<String, Object> pair = it.next();
            String key = pair.getKey();
            if (first) {
                first = false;
                if (this.style == Style.DEFAULT) {
                    s = s + "\n" + PrettyJson.repeat(' ', indent + 2);
                } else if (this.style == Style.COMPACT) {
                    // empty if block
                }
            } else {
                s = s + PrettyJson.repeat(' ', indent + 2);
            }
            s = s + "\"" + JSONObject.escape(key) + "\"";
            s = s + PrettyJson.repeat(' ', maxKeyLen - key.length()) + " : ";
            Object value = pair.getValue();
            if (value instanceof Boolean) {
                s = s + this.format((Boolean)value);
            } else if (value instanceof Number) {
                s = s + this.format((Number)value);
            } else if (value instanceof String) {
                s = s + this.format((String)value);
            } else if (value instanceof List) {
                s = s + this.format((List)value, subIndent);
            } else if (value instanceof Map) {
                s = s + this.format((Map)value, subIndent);
            } else if (value == null) {
                s = s + this.formatNull();
            }
            if (!it.hasNext()) continue;
            s = s + ",";
            s = s + "\n";
        }
        if (this.style == Style.DEFAULT) {
            return s + "\n" + PrettyJson.repeat(' ', indent) + "}";
        }
        return s + " }";
    }

    public String format(Map<String, Object> o) {
        return this.format(o, 0);
    }

    public String parseAndFormat(String jsonTxt) throws java.text.ParseException {
        Object o = null;
        try {
            o = parser.parse(jsonTxt, containerFactory);
        }
        catch (ParseException e) {
            throw new java.text.ParseException(e.getMessage(), e.getPosition());
        }
        if (o == null) {
            return this.formatNull();
        }
        if (o instanceof Boolean) {
            return this.format((Boolean)o);
        }
        if (o instanceof Number) {
            return this.format((Number)o);
        }
        if (o instanceof String) {
            return this.format((String)o);
        }
        if (o instanceof List) {
            return this.format((List)o);
        }
        if (o instanceof Map) {
            return this.format((Map)o);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readStdIn() throws IOException {
        StringBuilder contents = new StringBuilder();
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        finally {
            input.close();
        }
        return contents.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File file) throws IOException {
        StringBuilder contents = new StringBuilder();
        BufferedReader input = new BufferedReader(new FileReader(file));
        try {
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        finally {
            input.close();
        }
        return contents.toString();
    }

    private static void writeFile(File file, String content) throws IOException {
        FileWriter fstream = new FileWriter(file);
        BufferedWriter out = new BufferedWriter(fstream);
        out.write(content);
        out.close();
    }

    protected static void printUsage() {
        System.out.println("Usage: java -jar PrettyJson.jar [-compact] json-input-file [json-output-file]");
        System.out.println("   or: java -jar PrettyJson.jar [-compact] < json-std-in > json-std-out");
    }

    public static void main(String[] args) {
        File inFile = null;
        File outFile = null;
        boolean compactStyleOn = false;
        for (String arg : args) {
            if (arg.equals("-compact")) {
                compactStyleOn = true;
                continue;
            }
            if (inFile == null) {
                inFile = new File(arg);
                continue;
            }
            if (outFile == null) {
                outFile = new File(arg);
                continue;
            }
            PrettyJson.printUsage();
            System.exit(1);
        }
        String jsonInput = null;
        try {
            if (inFile != null) {
                jsonInput = PrettyJson.readFile(inFile);
            } else if (System.in.available() > 0) {
                jsonInput = PrettyJson.readStdIn();
            } else {
                PrettyJson.printUsage();
                System.exit(1);
            }
        }
        catch (IOException e) {
            System.err.println("Error reading JSON input: " + e.getMessage());
            System.exit(1);
        }
        PrettyJson formatter = null;
        formatter = compactStyleOn ? new PrettyJson(Style.COMPACT) : new PrettyJson(Style.DEFAULT);
        String jsonOutput = null;
        try {
            jsonOutput = formatter.parseAndFormat(jsonInput);
        }
        catch (java.text.ParseException e) {
            System.err.println("Error parsing JSON input: " + e.getMessage());
            System.exit(1);
        }
        if (outFile != null) {
            try {
                PrettyJson.writeFile(outFile, jsonOutput + "\n");
            }
            catch (IOException e) {
                System.err.println("Error writing JSON output: " + e.getMessage());
                System.exit(1);
            }
        } else {
            System.out.println(jsonOutput);
        }
    }

    public static enum Style {
        DEFAULT,
        COMPACT;

    }
}

