package com.nimbusds.openid.connect.provider.jwkset.validator;


import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.openid.connect.provider.jwkset.JWKSetSpec;


/**
 * OpenID Federation 1.0 entity JWK set validator.
 */
public final class FederationJWKSetValidator {
	
	
	/**
	 * Validates the minimum required JWK set for an OpenID Federation 1.0
	 * entity.
	 *
	 * <ul>
	 *     <li>One signing RSA key pair
	 * </ul>
	 *
	 * @see JWKSetSpec
	 *
	 * @param jwkSet The JWK set to validate.
	 *
	 * @throws JOSEException If validation failed.
	 */
	public static void validateMinimumRequired(final JWKSet jwkSet)
		throws JOSEException {
		
		JWKMatcher rsaSigningKeyMatcher = JWKSetSpec.RotatedRSASigning.createKeyMatcher(JWSAlgorithm.RS256);
		
		if (new JWKSelector(rsaSigningKeyMatcher).select(jwkSet).isEmpty()) {
			throw new JOSEException("The JWK set must contain at least one signing RSA key pair with properties: " + rsaSigningKeyMatcher);
		}
	}
}
