package com.nimbusds.openid.connect.provider.spi;


import java.io.InputStream;
import java.net.URI;
import javax.servlet.ServletContext;

import com.nimbusds.oauth2.sdk.id.Issuer;
import org.infinispan.manager.EmbeddedCacheManager;


/**
 * Context for the initialisation of SPI implementations.
 *
 * <p>Provides:
 *
 * <ul>
 *     <li>Access to the web application context.
 *     <li>A method to retrieve a configuration or another file in the web
 *         application package.
 *     <li>Access to the Infinispan cache manager.
 * </ul>
 */
public interface InitContext {
	
	
	/**
	 * Returns the servlet context.
	 *
	 * @return The servlet context.
	 */
	ServletContext getServletContext();


	/**
	 * Returns the resource located at the named path as an input stream.
	 * Has the same behaviour as
	 * {@link javax.servlet.ServletContext#getResourceAsStream}.
	 *
	 * @param path The path to the resource, must be begin with a '/' and
	 *             is interpreted as relative to the web application root.
	 *             Must not be {@code null}.
	 *
	 * @return The resource as an input stream, or {@code null} if no
	 *         resource exists at the specified path.
	 */
	InputStream getResourceAsStream(final String path);
	
	
	/**
	 * Returns the Infinispan cache manager.
	 *
	 * @return The Infinispan cache manager.
	 */
	EmbeddedCacheManager getInfinispanCacheManager();


	/**
	 * Returns the OpenID Provider / Authorisation Server issuer URL. May
	 * be used to set the accepted audience values for SAML 2.0 or JWT
	 * bearer grant handlers.
	 *
	 * <p>Use {@link InvocationContext#getIssuer()} instead.
	 *
	 * @return The OpenID Provider / Authorisation Server issuer,
	 *         {@code null} if not available (for a multi-tenant Connect2id
	 *         server).
	 */
	@Deprecated
	Issuer getIssuer();
	
	
	/**
	 * Returns the OpenID Provider / Authorisation Server issuer URL. May
	 * be used to set the accepted audience values for SAML 2.0 or JWT
	 * bearer grant handlers.
	 *
	 * <p>Use {@link InvocationContext#getIssuer()} instead.
	 *
	 * @return The OpenID Provider / Authorisation Server issuer,
	 *         {@code null} if not available (for a multi-tenant Connect2id
	 *         server).
	 */
	@Deprecated
	Issuer getOPIssuer();


	/**
	 * Returns the token endpoint of the OpenID Provider / Authorisation
	 * Server. May be used to set the accepted audience values for SAML 2.0
	 * or JWT bearer grant handlers.
	 *
	 * @return The token endpoint URI, {@code null} if not available (for a
	 *         multi-tenant Connect2id server).
	 */
	@Deprecated
	URI getTokenEndpointURI();


	/**
	 * Returns a service context for accessing selected Connect2id server
	 * components that may be required in order to process claims or grant
	 * handler requests. The service context is only available during SPI
	 * request processing. Attempting to use it during SPI
	 * {@link Lifecycle#init ininitialisation} will produce an
	 * {@link IllegalStateException}.
	 *
	 * <p>Use {@link InvocationContext} instead.
	 *
	 * @return The service context.
	 */
	@Deprecated
	ServiceContext getServiceContext();
}

