package com.nimbusds.openid.connect.provider.spi.claims;


import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.openid.connect.provider.spi.InvocationContext;
import com.nimbusds.openid.connect.provider.spi.tokens.TokenEncoderContext;
import com.nimbusds.openid.connect.sdk.claims.ClaimsTransport;


/**
 * OpenID Connect claims request context. The supplied context parameters can
 * be used in the processing and accounting of a claims request.
 */
public interface ClaimsSourceRequestContext extends InvocationContext {
	
	
	/**
	 * Returns the claims transport, if applicable.
	 *
	 * @return {@link ClaimsTransport#USERINFO UserInfo} or
	 *         {@link ClaimsTransport#ID_TOKEN ID token}, {@code null} if
	 *         the claims source SPI is invoked for another purpose (e.g.
	 *         in a {@link TokenEncoderContext}).
	 */
	ClaimsTransport getClaimsTransport();


	/**
	 * Returns the identifier of the OAuth 2.0 client (client_id).
	 *
	 * @return The client ID. Not {@code null}.
	 */
	ClientID getClientID();
	
	
	/**
	 * Returns the client IP address.
	 *
	 * @return The client IP address, {@code null} if not available.
	 */
	String getClientIPAddress();
	
	
	/**
	 * Returns the received and successfully validated UserInfo access
	 * token for the claims request. If a claims request is triggered in a
	 * OpenID Connect implicit and hybrid flows, where the claims are
	 * returned as part of the ID token, an access token is not involved
	 * and hence not returned by this method.
	 *
	 * <p>The claims source may use the UserInfo access token for the
	 * retrieval of aggregated and distributed claims, where the same token
	 * is recognised by the upstream claims providers. See OpenID Connect
	 * Core 1.0, section 5.6.
	 *
	 * @return The UserInfo access token, {@code null} if the claims
	 *         request wasn't triggered by a UserInfo request.
	 */
	AccessToken getUserInfoAccessToken();
}
