package com.nimbusds.openid.connect.provider.spi.claims;


import java.util.Set;

import net.jcip.annotations.ThreadSafe;


/**
 * Interface for querying OpenID Connect claims support. Implementations must
 * be thread-safe.
 */
@ThreadSafe
public interface ClaimsSupport {


	/**
	 * Returns the names of the supported OpenID Connect claims. The claim
	 * names may include a wildcard character '*' to indicate support for a
	 * pattern of claims, e.g. "id4me.*" for claims with a common prefix.
	 *
	 * <p>Example:
	 *
	 * <pre>
	 * name
	 * email
	 * email_verified
	 * </pre>
	 *
	 * @return The supported claim names. Should not include the reserved
	 *         {@code sub} (subject) claim name.
	 */
	Set<String> supportedClaims();
}
