package com.nimbusds.openid.connect.provider.spi.events;


import java.util.EventListener;

import com.nimbusds.openid.connect.provider.spi.Lifecycle;


/**
 * Service Provider Interface (SPI) for listening to access token issue events.
 */
public interface AccessTokenIssueEventListener extends Lifecycle, EventListener {
	
	
	/**
	 * This method is called when an access token is issued.
	 *
	 * @param event        The access token issue event. Not {@code null}.
	 * @param eventContext Provides access to additional parameters about
	 *                     the event as well as helpers for its
	 *                     processing. Not {@code null}.
	 */
	void accessTokenIssued(final AccessTokenIssueEvent event, final EventContext eventContext);
}
