package com.nimbusds.openid.connect.provider.spi.events;


import com.nimbusds.openid.connect.provider.spi.InvocationContext;
import com.nimbusds.openid.connect.provider.spi.crypto.JWTSigner;


/**
 * Event context.
 */
public interface EventContext extends InvocationContext {
	
	
	/**
	 * Returns an interface for signing JSON Web Tokens (JWT). May be used
	 * to sign security event tokens (SET) produced by the event listener.
	 *
	 * @return The JWT signer.
	 */
	JWTSigner getJWTSigner();
}
