package com.nimbusds.openid.connect.provider.spi.events;


import com.nimbusds.jwt.JWTClaimsSet;
import net.jcip.annotations.Immutable;


/**
 * ID token issue event.
 */
@Immutable
public class IDTokenIssueEvent extends JWTIssueEvent {
	
	
	/**
	 * Creates a new ID token issue event.
	 *
	 * @param source       The object that originated the event.
	 * @param jwtClaimsSet The ID token claims set.
	 */
	public IDTokenIssueEvent(final Object source, final JWTClaimsSet jwtClaimsSet) {
		super(source, jwtClaimsSet);
	}
}
