package com.nimbusds.openid.connect.provider.spi.grants;


import com.nimbusds.oauth2.sdk.ParseException;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;


/**
 * Refresh token specification.
 */
@Immutable
public class RefreshTokenSpec extends OptionalTokenSpec {


	/**
	 * Default refresh token specification (no issue).
	 */
	public static final RefreshTokenSpec DEFAULT = new RefreshTokenSpec();


	/**
	 * Creates a new default refresh token specification (no issue).
	 */
	public RefreshTokenSpec() {

		this(false, 0L);
	}


	/**
	 * Creates a new refresh token specification.
	 *
	 * @param issue    Controls the refresh token issue. If {@code true}
	 *                 a refresh token must be issued (requires a
	 *                 long-lived authorisation), {@code false} to prohibit
	 *                 issue.
	 * @param lifetime The refresh token lifetime, in seconds. Zero implies
	 *                 permanent (no expiration). Applies only if a refresh
	 *                 token is issued.
	 */
	public RefreshTokenSpec(final boolean issue, long lifetime) {

		super(issue, lifetime, null, null);
	}


	/**
	 * Parses a refresh token specification from the specified JSON object.
	 *
	 * @param o The JSON object. Must not be {@code null}.
	 *
	 * @return The refresh token specification.
	 *
	 * @throws ParseException If parsing failed.
	 */
	public static RefreshTokenSpec parse(final JSONObject o)
		throws ParseException {

		OptionalTokenSpec optionalTokenSpec = OptionalTokenSpec.parse(o);
		return new RefreshTokenSpec(optionalTokenSpec.issue(), optionalTokenSpec.getLifetime());
	}
}
