package com.nimbusds.openid.connect.provider.spi.tokens.introspection;


import com.nimbusds.openid.connect.provider.spi.InvocationContext;
import com.nimbusds.openid.connect.provider.spi.claims.ClaimsSource;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;


/**
 * Token introspection context.
 */
public interface TokenIntrospectionContext extends InvocationContext {
	
	
	/**
	 * If the requesting client authenticated at the introspection
	 * endpoint returns its registered information.
	 *
	 * @return The client information, {@code null} if the introspection
	 *         request was authorised with an access token.
	 */
	OIDCClientInformation getOIDCClientInformation();
	
	
	/**
	 * Returns the OpenID claims source.
	 *
	 * @return The OpenID claims source.
	 */
	ClaimsSource getClaimsSource();
}
