/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.dynamodb;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Index;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.spec.GetItemSpec;
import com.amazonaws.services.dynamodbv2.model.ContinuousBackupsStatus;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeContinuousBackupsRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeContinuousBackupsResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTimeToLiveRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTimeToLiveResult;
import com.amazonaws.services.dynamodbv2.model.PointInTimeRecoverySpecification;
import com.amazonaws.services.dynamodbv2.model.ResourceInUseException;
import com.amazonaws.services.dynamodbv2.model.TimeToLiveSpecification;
import com.amazonaws.services.dynamodbv2.model.TimeToLiveStatus;
import com.amazonaws.services.dynamodbv2.model.UpdateContinuousBackupsRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTimeToLiveRequest;
import com.codahale.metrics.Timer;
import com.nimbusds.infinispan.persistence.common.InfinispanEntry;
import com.nimbusds.infinispan.persistence.common.InfinispanStore;
import com.nimbusds.infinispan.persistence.common.query.QueryExecutor;
import com.nimbusds.infinispan.persistence.dynamodb.DynamoDBItemTransformer;
import com.nimbusds.infinispan.persistence.dynamodb.DynamoDBMeters;
import com.nimbusds.infinispan.persistence.dynamodb.ExpiredEntryReaper;
import com.nimbusds.infinispan.persistence.dynamodb.InvalidHMACException;
import com.nimbusds.infinispan.persistence.dynamodb.ItemHMAC;
import com.nimbusds.infinispan.persistence.dynamodb.RequestFactory;
import com.nimbusds.infinispan.persistence.dynamodb.config.DynamoDBStoreConfiguration;
import com.nimbusds.infinispan.persistence.dynamodb.logging.Loggers;
import com.nimbusds.infinispan.persistence.dynamodb.query.DynamoDBQueryExecutor;
import com.nimbusds.infinispan.persistence.dynamodb.query.DynamoDBQueryExecutorInitContext;
import io.reactivex.Flowable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import net.jcip.annotations.ThreadSafe;
import org.apache.logging.log4j.util.Supplier;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.persistence.Store;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.persistence.spi.AdvancedCacheExpirationWriter;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.reactivestreams.Publisher;

@ThreadSafe
@ConfiguredBy(value=DynamoDBStoreConfiguration.class)
@Store(shared=true)
public class DynamoDBStore<K, V>
extends InfinispanStore<K, V> {
    private DynamoDBStoreConfiguration config;
    private AmazonDynamoDB client;
    private Table table;
    private DynamoDBItemTransformer<K, V> itemTransformer;
    private DynamoDBQueryExecutor<K, V> queryExecutor;
    private RequestFactory<K, V> requestFactory;
    private ItemHMAC itemHMAC;
    private MarshalledEntryFactory<K, V> marshalledEntryFactory;
    private ExpiredEntryReaper<K, V> reaper;
    private DynamoDBMeters meters;

    private DynamoDBItemTransformer<K, V> loadItemTransformerClass(Class<?> clazz) {
        try {
            Class<?> genClazz = clazz;
            return (DynamoDBItemTransformer)genClazz.newInstance();
        }
        catch (Exception e) {
            throw new PersistenceException("Couldn't load DynamoDB item transformer class: " + e.getMessage(), (Throwable)e);
        }
    }

    private DynamoDBQueryExecutor<K, V> loadQueryExecutorClass(Class<?> clazz) {
        try {
            Class<?> genClazz = clazz;
            return (DynamoDBQueryExecutor)genClazz.newInstance();
        }
        catch (Exception e) {
            throw new PersistenceException("Couldn't load DynamoDB query executor class: " + e.getMessage(), (Throwable)e);
        }
    }

    public DynamoDBStoreConfiguration getConfiguration() {
        return this.config;
    }

    public Table getTable() {
        return this.table;
    }

    public DynamoDBItemTransformer<K, V> getItemTransformer() {
        return this.itemTransformer;
    }

    public QueryExecutor<K, V> getQueryExecutor() {
        return this.queryExecutor;
    }

    public DynamoDBMeters getMeters() {
        return this.meters;
    }

    public void init(InitializationContext ctx) {
        super.init(ctx);
        this.config = (DynamoDBStoreConfiguration)ctx.getConfiguration();
        Loggers.MAIN_LOG.info("[DS0100] DynamoDB store: Infinispan cache store configuration for {}:", (Object)this.getCacheName());
        this.config.log();
        AmazonDynamoDBClientBuilder builder = (AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withCredentials((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
        if (this.config.getEndpoint() != null && !this.config.getEndpoint().trim().isEmpty()) {
            builder = (AmazonDynamoDBClientBuilder)builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.config.getEndpoint(), null));
        }
        if (this.config.getRegion() != null) {
            builder = (AmazonDynamoDBClientBuilder)builder.withRegion(this.config.getRegion());
        }
        if (this.config.getHTTPProxyHost() != null) {
            ClientConfiguration clientConfig = new ClientConfiguration().withProxyHost(this.config.getHTTPProxyHost());
            if (this.config.getHTTPProxyPort() > -1) {
                clientConfig.withProxyPort(this.config.getHTTPProxyPort());
            }
            builder = (AmazonDynamoDBClientBuilder)builder.withClientConfiguration(clientConfig);
        }
        try {
            this.itemHMAC = new ItemHMAC(this.config.getHMACSHA256Key());
        }
        catch (InvalidKeyException e) {
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
        this.client = (AmazonDynamoDB)builder.build();
        Loggers.MAIN_LOG.info("[DS0140] DynamoDB store: Expiration thread wake up interval for cache {}: {}", (Object)this.getCacheName(), (Object)ctx.getCache().getCacheConfiguration().expiration().wakeUpInterval());
        Loggers.MAIN_LOG.debug("[DS0101] Loading DynamoDB item transformer class {} for cache {}...", (Object)this.config.getItemTransformerClass(), (Object)this.getCacheName());
        this.itemTransformer = this.loadItemTransformerClass(this.config.getItemTransformerClass());
        this.itemTransformer.init(() -> this.config.isEnableTTL());
        this.requestFactory = new RequestFactory<K, V>(this.itemTransformer, this.config.getIndexedAttributes(), this.config.isConsistentReads(), this.config.getProvisionedThroughput(), this.config.isTableWithEncryptionAtRest(), this.config.getTablePrefix(), this.config.getApplyRangeKey(), this.config.getRangeKeyValue(), this.config.isEnableStream());
        this.table = new DynamoDB(this.client).getTable(this.requestFactory.getTableName());
        if (this.config.getQueryExecutorClass() != null) {
            Loggers.MAIN_LOG.debug("[DS0130] Loading optional DynamoDB query executor class {} for cache {}...", (Object)this.config.getQueryExecutorClass(), (Object)this.getCacheName());
            this.queryExecutor = this.loadQueryExecutorClass(this.config.getQueryExecutorClass());
            this.queryExecutor.init(new DynamoDBQueryExecutorInitContext<K, V>(){

                @Override
                public DynamoDBItemTransformer<K, V> getDynamoDBItemTransformer() {
                    return DynamoDBStore.this.itemTransformer;
                }

                @Override
                public Table getDynamoDBTable() {
                    return DynamoDBStore.this.table;
                }

                @Override
                public Index getDynamoDBIndex(String attributeName) {
                    if (DynamoDBStore.this.config.getIndexedAttributes() != null && DynamoDBStore.this.config.getIndexedAttributes().contains(attributeName)) {
                        return DynamoDBStore.this.table.getIndex(DynamoDBStore.this.requestFactory.getGSIName(attributeName));
                    }
                    return null;
                }
            });
        }
        this.marshalledEntryFactory = ctx.getMarshalledEntryFactory();
        String metricsPrefix = ctx.getCache().getName() + ".";
        this.meters = this.config.getMetricRegistry() == null ? new DynamoDBMeters(metricsPrefix) : new DynamoDBMeters(metricsPrefix, this.config.getMetricRegistry());
        Loggers.MAIN_LOG.info("[DS0102] Initialized DynamoDB store for cache {} with table {}", (Object)this.getCacheName(), (Object)this.table.getTableName());
    }

    public void start() {
        CreateTableRequest ctr = this.requestFactory.resolveCreateTableRequest();
        try {
            this.table = new DynamoDB(this.client).createTable(ctr.withProvisionedThroughput(this.config.getProvisionedThroughput()));
            Loggers.MAIN_LOG.info("[DS0129] DynamoDB store: Created table {} for cache {}", (Object)this.table.getTableName(), (Object)this.getCacheName());
        }
        catch (ResourceInUseException e) {
            Loggers.MAIN_LOG.info("[DS0133] DynamoDB store: Table {} for cache {} exists", (Object)this.table.getTableName(), (Object)this.getCacheName());
        }
        catch (Exception e) {
            Loggers.MAIN_LOG.fatal("[DS0103] DynamoDB store: Couldn't create table {} with {}: {}: {}", (Object)this.table.getTableName(), (Object)ctr, (Object)e.getMessage(), (Object)e);
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
        try {
            this.table.waitForActive();
        }
        catch (InterruptedException e) {
            throw new PersistenceException("Interrupted while awaiting DynamoDB table " + this.table.getTableName() + " to become active: " + e.getMessage(), (Throwable)e);
        }
        Loggers.MAIN_LOG.info("[DS0141] DynamoDB store: Table properties: " + this.table.getDescription());
        ContinuousBackupsStatus contBackupStatus = null;
        try {
            DescribeContinuousBackupsResult result = this.client.describeContinuousBackups(new DescribeContinuousBackupsRequest().withTableName(this.table.getTableName()));
            contBackupStatus = ContinuousBackupsStatus.fromValue((String)result.getContinuousBackupsDescription().getContinuousBackupsStatus());
            Loggers.MAIN_LOG.info("[DS0143] DynamoDB store: Continuous backup status for table {}: {}", (Object)this.table.getTableName(), (Object)contBackupStatus);
            Loggers.MAIN_LOG.info("[DS0144] DynamoDB store: Point in time recovery status for table {}: {}", (Object)this.table.getTableName(), (Object)result.getContinuousBackupsDescription().getPointInTimeRecoveryDescription().getPointInTimeRecoveryStatus());
        }
        catch (Exception e) {
            Loggers.MAIN_LOG.error("[DS0145] DynamoDB store: Couldn't obtain continuous backup status for table {}: {}", (Object)this.table.getTableName(), (Object)e.getMessage());
        }
        if (ContinuousBackupsStatus.DISABLED.equals(contBackupStatus) && this.config.isEnableContinuousBackups()) {
            try {
                this.client.updateContinuousBackups(new UpdateContinuousBackupsRequest().withTableName(this.table.getTableName()).withPointInTimeRecoverySpecification(new PointInTimeRecoverySpecification().withPointInTimeRecoveryEnabled(Boolean.valueOf(true))));
            }
            catch (Exception e) {
                String msg = "Couldn't set up continuous backups for table " + this.table.getTableName() + ": " + e.getMessage();
                Loggers.MAIN_LOG.fatal("[DS0104] DynamoDB store: {}", (Object)msg);
                throw new PersistenceException(msg, (Throwable)e);
            }
        }
        TimeToLiveStatus currentTTLStatus = null;
        try {
            DescribeTimeToLiveResult result = this.client.describeTimeToLive(new DescribeTimeToLiveRequest().withTableName(this.table.getTableName()));
            currentTTLStatus = TimeToLiveStatus.fromValue((String)result.getTimeToLiveDescription().getTimeToLiveStatus());
            Loggers.MAIN_LOG.info("[DS0161] DynamoDB store: TTL for table {}: status={} attribute={}", (Object)this.table.getTableName(), (Object)currentTTLStatus, (Object)result.getTimeToLiveDescription().getAttributeName());
        }
        catch (Exception e) {
            Loggers.MAIN_LOG.error("[DS0162] DynamoDB store: Couldn't obtain TTL status for table {}: {}", (Object)this.table.getTableName(), (Object)e.getMessage());
        }
        if (TimeToLiveStatus.DISABLED.equals(currentTTLStatus) && this.config.isEnableTTL() && this.requestFactory.getItemTransformer().getTTLAttributeName() != null) {
            try {
                this.client.updateTimeToLive(new UpdateTimeToLiveRequest().withTableName(this.table.getTableName()).withTimeToLiveSpecification(new TimeToLiveSpecification().withAttributeName(this.requestFactory.getItemTransformer().getTTLAttributeName()).withEnabled(Boolean.valueOf(true))));
            }
            catch (Exception e) {
                String msg = "Couldn't set up TTL for table " + this.table.getTableName() + ": " + e.getMessage();
                Loggers.MAIN_LOG.fatal("[DS0160] DynamoDB store: {}", (Object)msg);
                throw new PersistenceException(msg, (Throwable)e);
            }
        }
        this.reaper = new ExpiredEntryReaper<K, V>(this.marshalledEntryFactory, this.table, this.requestFactory, this.config.getPurgeLimit(), this.meters.purgeTimer);
        Loggers.MAIN_LOG.info("[DS0104] Started DynamoDB external store connector for cache {} with table {}", (Object)this.getCacheName(), (Object)this.table.getTableName());
    }

    public void stop() {
        super.stop();
        if (this.client != null) {
            this.client.shutdown();
        }
        Loggers.MAIN_LOG.info("[DS0105] Stopped DynamoDB store connector for cache {}", (Object)this.getCacheName());
    }

    public boolean contains(Object key) {
        Loggers.DYNAMODB_LOG.trace("[DS0106] DynamoDB store: Checking {} cache key {}", (Object)this.getCacheName(), key);
        Timer.Context timerCtx = this.meters.getTimer.time();
        try {
            boolean bl = this.table.getItem(this.requestFactory.resolveGetItemSpec(key)) != null;
            return bl;
        }
        catch (Exception e) {
            Loggers.DYNAMODB_LOG.error("[DS0107] {}: {}", (Object)e.getMessage(), (Object)e);
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
        finally {
            timerCtx.stop();
        }
    }

    public MarshalledEntry<K, V> load(Object key) {
        Item item;
        Loggers.DYNAMODB_LOG.trace("[DS0108] DynamoDB store: Loading {} cache entry with key {}", (Object)this.getCacheName(), key);
        Timer.Context timerCtx = this.meters.getTimer.time();
        GetItemSpec getItemSpec = this.requestFactory.resolveGetItemSpec(key);
        try {
            item = this.table.getItem(getItemSpec);
        }
        catch (Exception e) {
            Loggers.DYNAMODB_LOG.error("[DS0109] {}, {}", (Object)e.getMessage(), (Object)e);
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
        finally {
            timerCtx.stop();
        }
        if (item == null) {
            Loggers.DYNAMODB_LOG.trace("[DS0110] DynamoDB store: Item with key {} not found", key);
            return null;
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> ((DynamoDBStore)this).getCacheName();
        supplierArray[1] = () -> ((Item)item).toJSON();
        Loggers.DYNAMODB_LOG.trace("[DS0111] DynamoDB store: Retrieved {} cache item: {}", supplierArray);
        try {
            item = this.itemHMAC.verify(item);
        }
        catch (InvalidHMACException e) {
            this.meters.invalidItemHmacCounter.inc();
            Loggers.DYNAMODB_LOG.error("[DS0131] DynamoDB store: Invalid item HMAC in {}: {}", (Object)this.getCacheName(), (Object)e.getMessage());
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
        InfinispanEntry<K, V> infinispanEntry = this.itemTransformer.toInfinispanEntry(item);
        if (infinispanEntry.isExpired()) {
            Loggers.DYNAMODB_LOG.trace("[DS0114] DynamoDB store: Item with key {} expired", key);
            return null;
        }
        return this.marshalledEntryFactory.newMarshalledEntry(infinispanEntry.getKey(), infinispanEntry.getValue(), infinispanEntry.getMetadata());
    }

    public boolean delete(Object key) {
        boolean deleted;
        Loggers.DYNAMODB_LOG.trace("[DS0112] DynamoDB store: Deleting {} cache entry with key {}", (Object)this.getCacheName(), key);
        Timer.Context timerCtx = this.meters.deleteTimer.time();
        try {
            deleted = this.table.deleteItem(this.requestFactory.resolveDeleteItemSpec(key)).getItem() != null;
        }
        catch (Exception e) {
            Loggers.DYNAMODB_LOG.error("[DS0113] {}, {}", (Object)e.getMessage(), (Object)e);
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
        finally {
            timerCtx.stop();
        }
        if (deleted) {
            Loggers.DYNAMODB_LOG.trace("[DS0116] DynamoDB store: Deleted {} cache item with key {}", (Object)this.getCacheName(), key);
        }
        return deleted;
    }

    public void write(MarshalledEntry<? extends K, ? extends V> marshalledEntry) {
        Loggers.DYNAMODB_LOG.trace("[DS0115] DynamoDB store: Writing {} cache entry {}", (Object)this.getCacheName(), marshalledEntry);
        Timer.Context timerCtx = this.meters.putTimer.time();
        try {
            Item item = this.requestFactory.resolveItem(new InfinispanEntry(marshalledEntry.getKey(), marshalledEntry.getValue(), marshalledEntry.getMetadata()));
            item = this.itemHMAC.apply(item);
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((DynamoDBStore)this).getCacheName();
            supplierArray[1] = () -> ((Item)item).toJSON();
            Loggers.DYNAMODB_LOG.trace("[DS0132] DynamoDB store: Writing {} cache item: {}", supplierArray);
            this.table.putItem(item);
        }
        catch (Exception e) {
            Loggers.DYNAMODB_LOG.error("[DS0117] {}: {}", (Object)e.getMessage(), (Object)e);
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
        finally {
            timerCtx.stop();
        }
    }

    public Publisher<MarshalledEntry<K, V>> publishEntries(Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
        Loggers.DYNAMODB_LOG.trace("[DS0118] DynamoDB store: Processing key filter for {} cache: fetchValue={} fetchMetadata={}", (Object)this.getCacheName(), (Object)fetchValue, (Object)fetchMetadata);
        Instant now = Instant.now();
        return Flowable.using(() -> ((Timer)this.meters.processTimer).time(), ignore -> Flowable.fromIterable(this.requestFactory.getAllItems(this.table)).map(this.itemTransformer::toInfinispanEntry).filter(infinispanEntry -> filter == null || filter.test((Object)infinispanEntry.getKey())).filter(infinispanEntry -> !infinispanEntry.isExpired(now)).map(infinispanEntry -> this.marshalledEntryFactory.newMarshalledEntry(infinispanEntry.getKey(), infinispanEntry.getValue(), infinispanEntry.getMetadata())).doOnError(e -> Loggers.DYNAMODB_LOG.error("[DS0119] {}: {}", (Object)e.getMessage(), e)), Timer.Context::stop);
    }

    public int size() {
        int count;
        Loggers.DYNAMODB_LOG.trace("[DS0120] DynamoDB store: Counting {} cache items", (Object)this.getCacheName());
        try {
            count = this.table.describe().getItemCount().intValue();
        }
        catch (Exception e) {
            Loggers.DYNAMODB_LOG.error("[DS0121] {}: {}", (Object)e.getMessage(), (Object)e);
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
        Loggers.DYNAMODB_LOG.trace("[DS0122] DynamoDB store: Reported approximately {} {} items", (Object)count, (Object)this.getCacheName());
        return count;
    }

    public void clear() {
        Loggers.DYNAMODB_LOG.trace("[DS0123] DynamoDB store: Clearing {} items", (Object)this.getCacheName());
        if (this.requestFactory.getRangeKeyResolvedName() != null) {
            throw new PersistenceException("DynamoDB clear operation not supported with applied range key");
        }
        try {
            DeleteTableResult result = this.table.delete();
            int numDeleted = result.getTableDescription().getItemCount().intValue();
            Loggers.DYNAMODB_LOG.info("[DS0125] DynamoDB store: Cleared {} {} items", (Object)numDeleted, (Object)this.table.getTableName());
            this.table.waitForDelete();
            this.client.createTable(this.requestFactory.resolveCreateTableRequest());
            this.table.waitForActive();
        }
        catch (Exception e) {
            Loggers.DYNAMODB_LOG.error("[DS0124] {}: {}", (Object)e.getMessage(), (Object)e);
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    public void purge(Executor executor, AdvancedCacheWriter.PurgeListener<? super K> purgeListener) {
        Loggers.DYNAMODB_LOG.trace("[DS0126] DynamoDB store: Purging {} cache entries", (Object)this.getCacheName());
        try {
            executor.execute(() -> this.reaper.purge(purgeListener));
        }
        catch (Exception e) {
            Loggers.DYNAMODB_LOG.error("[DS0127] {}: {}", (Object)e.getMessage(), (Object)e);
            throw new PersistenceException("Purge exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void purge(Executor executor, AdvancedCacheExpirationWriter.ExpirationPurgeListener<K, V> purgeListener) {
        Loggers.DYNAMODB_LOG.trace("[DS0150] DynamoDB store: Purging {} cache entries", (Object)this.getCacheName());
        try {
            executor.execute(() -> this.reaper.purgeExtended(purgeListener));
        }
        catch (Exception e) {
            Loggers.DYNAMODB_LOG.error("[DS0151] {}: {}", (Object)e.getMessage(), (Object)e);
            throw new PersistenceException("Purge exception: " + e.getMessage(), (Throwable)e);
        }
    }
}

